/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.mesh.MeshSigningKeyOwner;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@IdClass(value=PK.class)
@Table(name="bb_mesh_signing_key")
public class InternalMeshSigningKey {
    public static final String TABLE = "bb_mesh_signing_key";
    @Column(name="expiration_timestamp")
    private final Instant expirationTimestamp;
    @Column(name="fingerprint", length=50, updatable=false)
    @Id
    @RequiredString(size=50)
    private final String fingerprint;
    @Column(name="key_owner", updatable=false)
    @Id
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.internal.mesh.MeshSigningKeyOwner")})
    private final MeshSigningKeyOwner owner;
    @Column(name="private_der", length=4096, nullable=false, updatable=false)
    @Type(type="org.hibernate.type.BinaryType")
    private final byte[] privateKeyDer;
    @Column(name="public_der", length=1024, nullable=false, updatable=false)
    @Type(type="org.hibernate.type.BinaryType")
    private final byte[] publicKeyDer;

    protected InternalMeshSigningKey() {
        this.expirationTimestamp = null;
        this.fingerprint = null;
        this.owner = null;
        this.privateKeyDer = null;
        this.publicKeyDer = null;
    }

    private InternalMeshSigningKey(Builder builder) {
        this.expirationTimestamp = builder.expirationTimestamp;
        this.fingerprint = builder.fingerprint;
        this.owner = builder.owner;
        this.privateKeyDer = Objects.requireNonNull(builder.privateKeyDer, "privateKeyDer");
        this.publicKeyDer = Objects.requireNonNull(builder.publicKeyDer, "publicKeyDer");
    }

    @Nullable
    public Instant getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    @Nonnull
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Nonnull
    public MeshSigningKeyOwner getOwner() {
        return this.owner;
    }

    @Nonnull
    public byte[] getPrivateKeyDer() {
        return this.privateKeyDer;
    }

    @Nonnull
    public byte[] getPublicKeyDer() {
        return this.publicKeyDer;
    }

    public static class Builder
    extends BuilderSupport {
        private final String fingerprint;
        private final MeshSigningKeyOwner owner;
        private Instant expirationTimestamp;
        private byte[] publicKeyDer;
        private byte[] privateKeyDer;

        public Builder(@Nonnull InternalMeshSigningKey key) {
            this.expirationTimestamp = Objects.requireNonNull(key, "key").getExpirationTimestamp();
            this.fingerprint = key.getFingerprint();
            this.owner = key.getOwner();
            this.publicKeyDer = key.getPublicKeyDer();
            this.privateKeyDer = key.getPrivateKeyDer();
        }

        public Builder(@Nonnull MeshSigningKeyOwner owner, @Nonnull String fingerprint) {
            this.fingerprint = Builder.requireNonBlank((String)fingerprint, (String)"fingerprint");
            this.owner = Objects.requireNonNull(owner, "owner");
        }

        @Nonnull
        public InternalMeshSigningKey build() {
            return new InternalMeshSigningKey(this);
        }

        @Nonnull
        public Builder expirationTimestamp(@Nullable Instant value) {
            this.expirationTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder keyPair(@Nonnull KeyPair value) {
            return this.publicKey(Objects.requireNonNull(value, "keyPair").getPublic()).privateKey(value.getPrivate());
        }

        @Nonnull
        public Builder privateKey(@Nonnull PrivateKey value) {
            this.privateKeyDer = Objects.requireNonNull(value, "privateKey").getEncoded();
            return this;
        }

        @Nonnull
        public Builder privateKeyDer(@Nonnull byte[] value) {
            this.privateKeyDer = Objects.requireNonNull(value, "privateKeyDer");
            return this;
        }

        @Nonnull
        public Builder publicKey(@Nonnull PublicKey value) {
            this.publicKeyDer = Objects.requireNonNull(value, "publicKey").getEncoded();
            return this;
        }

        @Nonnull
        public Builder publicKeyDer(@Nonnull byte[] value) {
            this.publicKeyDer = Objects.requireNonNull(value, "publicKeyDer");
            return this;
        }
    }

    public static class PK
    implements Serializable {
        private final String fingerprint;
        private final MeshSigningKeyOwner owner;

        public PK(String fingerprint, MeshSigningKeyOwner owner) {
            this.fingerprint = fingerprint;
            this.owner = owner;
        }

        private PK() {
            this(null, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PK) {
                PK pk = (PK)o;
                return this.owner == pk.owner && this.fingerprint.equals(pk.fingerprint);
            }
            return false;
        }

        @Nonnull
        public String getFingerprint() {
            return this.fingerprint;
        }

        @Nonnull
        public MeshSigningKeyOwner getOwner() {
            return this.owner;
        }

        public int hashCode() {
            return 31 * this.owner.getId() + this.fingerprint.hashCode();
        }
    }
}

