/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.dmz.migration.MeshMigrationJob;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationJobState;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_mesh_migration_job", indexes={@Index(name="idx_bb_mesh_mgrtn_job_state", columnList="state"), @Index(name="idx_bb_mesh_mgrtn_job_stime", columnList="start_timestamp")})
@TableGenerator(allocationSize=25, pkColumnValue="bb_mesh_migration_job", name="meshMigrationJobIdGenerator", table="id_sequence")
public class InternalMeshMigrationJob
implements MeshMigrationJob {
    public static final String ID_GEN = "meshMigrationJobIdGenerator";
    public static final String TABLE = "bb_mesh_migration_job";
    @Column(name="end_timestamp")
    private final Instant endTime;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="meshMigrationJobIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="internal_job_id", nullable=false)
    private final long internalJobId;
    @Column(name="start_timestamp", nullable=false, updatable=false)
    private final Instant startTime;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.dmz.migration.MeshMigrationJobState")})
    private final MeshMigrationJobState state;

    private InternalMeshMigrationJob(Builder builder) {
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.internalJobId = builder.internalJobId;
        this.startTime = builder.startTime;
        this.state = builder.state;
    }

    protected InternalMeshMigrationJob() {
        this.endTime = null;
        this.id = 0L;
        this.internalJobId = 0L;
        this.startTime = null;
        this.state = MeshMigrationJobState.RUNNING;
    }

    @Nonnull
    public Optional<Instant> getEndTime() {
        return Optional.ofNullable(this.endTime);
    }

    public long getId() {
        return this.id;
    }

    public long getInternalJobId() {
        return this.internalJobId;
    }

    @Nonnull
    public Instant getStartTime() {
        return this.startTime;
    }

    @Nonnull
    public MeshMigrationJobState getState() {
        return this.state;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("state", (Object)this.getState()).add("internalJobId", this.getInternalJobId()).add("startTime", (Object)this.getStartTime()).add("endTime", this.getEndTime()).toString();
    }

    public static class Builder {
        private Instant endTime;
        private long id;
        private long internalJobId;
        private Instant startTime;
        private MeshMigrationJobState state;

        public Builder() {
            this.id = 0L;
            this.state = MeshMigrationJobState.RUNNING;
            this.startTime = Instant.now();
        }

        public Builder(@Nonnull MeshMigrationJob value) {
            Objects.requireNonNull(value, "value");
            this.endTime = value.getEndTime().orElse(null);
            this.id = value.getId();
            this.internalJobId = value.getInternalJobId();
            this.startTime = value.getStartTime();
            this.state = value.getState();
        }

        @Nonnull
        public InternalMeshMigrationJob build() {
            return new InternalMeshMigrationJob(this);
        }

        @Nonnull
        public Builder endTime(@Nullable Instant value) {
            this.endTime = value;
            return this;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder internalJobId(long value) {
            this.internalJobId = value;
            return this;
        }

        @Nonnull
        public Builder startTime(@Nonnull Instant value) {
            this.startTime = Objects.requireNonNull(value, "startTime");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull MeshMigrationJobState value) {
            this.state = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

