/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.migration;

import com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueItem;
import com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueState;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.migration.InternalMeshMigrationJob;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_mesh_migration_queue", indexes={@Index(name="idx_bb_mesh_mgrtn_q_state", columnList="state"), @Index(name="idx_bb_mesh_mgrtn_q_repo", columnList="repository_id"), @Index(name="idx_bb_mesh_mgrtn_q_jobid", columnList="migration_job_id")}, uniqueConstraints={@UniqueConstraint(name="uq_bb_mesh_mgrtn_q_repo_job", columnNames={"migration_job_id", "repository_id"})})
@TableGenerator(allocationSize=25, pkColumnValue="bb_mesh_migration_queue", name="meshMigrationQueueIdGenerator", table="id_sequence")
public class InternalMeshMigrationQueueItem
implements MeshMigrationQueueItem,
Initializable {
    public static final String ID_GEN = "meshMigrationQueueIdGenerator";
    public static final String TABLE = "bb_mesh_migration_queue";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="meshMigrationQueueIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @JoinColumn(name="migration_job_id", foreignKey=@ForeignKey(name="fk_bb_mesh_migration_job"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalMeshMigrationJob migrationJob;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.dmz.migration.MeshMigrationQueueState")})
    private final MeshMigrationQueueState state;
    @JoinColumn(name="repository_id", foreignKey=@ForeignKey(name="fk_bb_mesh_migration_repo"), updatable=false)
    @OneToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;

    private InternalMeshMigrationQueueItem(Builder builder) {
        this.id = builder.id;
        this.migrationJob = builder.migrationJob;
        this.repository = builder.repository;
        this.state = builder.state;
    }

    protected InternalMeshMigrationQueueItem() {
        this.id = 0L;
        this.migrationJob = null;
        this.state = MeshMigrationQueueState.QUEUED;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalMeshMigrationJob getMigrationJob() {
        return this.migrationJob;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public MeshMigrationQueueState getState() {
        return this.state;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getRepository());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("migrationJob", (Object)this.getMigrationJob()).add("repository", (Object)this.getRepository()).add("state", (Object)this.getState()).toString();
    }

    public static class Builder {
        private final InternalMeshMigrationJob migrationJob;
        private final InternalRepository repository;
        private long id;
        private MeshMigrationQueueState state;

        public Builder(@Nonnull InternalMeshMigrationJob migrationJob, @Nonnull InternalRepository repository) {
            this.id = 0L;
            this.migrationJob = Objects.requireNonNull(migrationJob, "migrationJob");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.state = MeshMigrationQueueState.QUEUED;
        }

        public Builder(@Nonnull InternalMeshMigrationQueueItem value) {
            Objects.requireNonNull(value, "value");
            this.id = value.getId();
            this.migrationJob = value.getMigrationJob();
            this.repository = value.getRepository();
            this.state = value.getState();
        }

        @Nonnull
        public InternalMeshMigrationQueueItem build() {
            return new InternalMeshMigrationQueueItem(this);
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull MeshMigrationQueueState value) {
            this.state = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

