/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;

@MappedSuperclass
public abstract class InternalAbstractMirrorHash {
    @Column(name="hash", length=64, nullable=false)
    @RequiredString(minimumSize=20, size=64)
    private final String hash;
    @Column(name="repository_id", nullable=false, unique=true, updatable=false)
    @Id
    private final int repositoryId;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;

    protected InternalAbstractMirrorHash() {
        this.hash = null;
        this.repositoryId = 0;
        this.updatedDate = null;
    }

    protected InternalAbstractMirrorHash(AbstractBuilder<?, ?> builder) {
        this.hash = builder.hash;
        this.repositoryId = builder.repositoryId;
        this.updatedDate = builder.updatedDate == null ? new Date() : builder.updatedDate;
    }

    @Nonnull
    public String getHash() {
        return this.hash;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    @Nonnull
    public abstract MirrorHashType getType();

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, T>, T extends InternalAbstractMirrorHash>
    extends BuilderSupport {
        private final int repositoryId;
        private String hash;
        private Date updatedDate;

        public AbstractBuilder(@Nonnull InternalAbstractMirrorHash mirrorHash) {
            this.hash = Objects.requireNonNull(mirrorHash, "mirrorHash").getHash();
            this.repositoryId = mirrorHash.getRepositoryId();
            this.updatedDate = mirrorHash.getUpdatedDate();
        }

        public AbstractBuilder(@Nonnull Repository repository) {
            this.repositoryId = Objects.requireNonNull(repository, "repository").getId();
        }

        public AbstractBuilder(int repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Nonnull
        public abstract T build();

        @Nonnull
        public B hash(@Nonnull String value) {
            this.hash = AbstractBuilder.requireNonBlank((String)value, (String)"hash");
            return this.self();
        }

        @Nonnull
        public B updatedDate(@Nonnull Date value) {
            this.updatedDate = Objects.requireNonNull(value, "updatedDate");
            return this.self();
        }

        protected abstract B self();
    }
}

