/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mirror.hash;

import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;

public class SimpleMirrorHashes
implements MirrorHashes {
    private final String contentHash;
    private final Date contentUpdatedDate;
    private final String metadataHash;
    private final Date metadataUpdatedDate;
    private final int projectId;
    private final boolean publiclyAccessible;
    private final int repositoryId;

    public SimpleMirrorHashes(int projectId, int repositoryId, String contentHash, Date contentUpdatedDate, String metadataHash, Date metadataUpdatedDate, Boolean publiclyAccessible) {
        this.contentHash = contentHash == null ? DmzMirrorHashService.NULL_HASH : contentHash;
        this.contentUpdatedDate = contentUpdatedDate;
        this.metadataHash = metadataHash == null ? DmzMirrorHashService.NULL_HASH : metadataHash;
        this.metadataUpdatedDate = metadataUpdatedDate;
        this.projectId = projectId;
        this.repositoryId = repositoryId;
        this.publiclyAccessible = publiclyAccessible != null && publiclyAccessible != false;
    }

    @Nonnull
    public String getContent() {
        return this.contentHash;
    }

    @Nullable
    public Date getContentUpdatedDate() {
        return this.contentUpdatedDate;
    }

    @Nonnull
    public String getMetadata() {
        return this.metadataHash;
    }

    @Nullable
    public Date getMetadataUpdatedDate() {
        return this.metadataUpdatedDate;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }
}

