/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.participant;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.participant.InternalParticipant;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.util.Objects;

@MappedSuperclass
public abstract class InternalAbstractParticipant<P extends InternalAbstractParticipant<P>>
implements Initializable,
InternalParticipant<P> {
    @JoinColumn(name="user_id", nullable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;

    protected InternalAbstractParticipant() {
    }

    protected InternalAbstractParticipant(AbstractParticipantBuilder<?, ?> builder) {
        this.user = builder.user;
    }

    @Override
    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        this.user = HibernateUtils.initialize(this.getUser());
    }

    protected static abstract class AbstractParticipantBuilder<B extends AbstractParticipantBuilder<B, E>, E extends InternalAbstractParticipant<E>> {
        private InternalApplicationUser user;

        protected AbstractParticipantBuilder() {
        }

        protected AbstractParticipantBuilder(@Nonnull E participant) {
            this.user = ((InternalAbstractParticipant)Objects.requireNonNull(participant, "participant")).getUser();
        }

        @Nonnull
        protected abstract B self();

        @Nonnull
        public B user(@Nonnull InternalApplicationUser value) {
            this.user = Objects.requireNonNull(value, "user");
            return this.self();
        }
    }
}

