/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.CustomPreconditions;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="plugin_setting", uniqueConstraints={@UniqueConstraint(name="uq_plug_setting_ns_key", columnNames={"key_name", "namespace"})})
@TableGenerator(allocationSize=20, pkColumnValue="plugin_setting", name="pluginSettingIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@NaturalIdCache
public class PluginSetting {
    public static final String ID_GEN = "pluginSettingIdGenerator";
    public static final String TABLE = "plugin_setting";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pluginSettingIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="namespace", nullable=false)
    @RequiredString
    @NaturalId
    private final String namespace;
    @Column(name="key_name", nullable=false)
    @RequiredString
    @NaturalId
    private final String key;
    @Column(name="key_value", nullable=false)
    @Lob
    @RequiredString(size=0x7FFFFFFF)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String value;

    protected PluginSetting() {
        this.id = 0L;
        this.namespace = null;
        this.key = null;
        this.value = null;
    }

    private PluginSetting(Builder builder) {
        CustomPreconditions.checkRequiredString((String)builder.key, (int)255);
        CustomPreconditions.checkRequiredString((String)builder.namespace, (int)255);
        CustomPreconditions.checkRequiredString((String)builder.value);
        this.id = builder.id;
        this.key = builder.key;
        this.namespace = builder.namespace;
        this.value = builder.value;
    }

    public long getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static class Builder {
        private final long id;
        private String key;
        private String namespace;
        private String value;

        public Builder() {
            this.id = 0L;
        }

        public Builder(@Nonnull PluginSetting settings) {
            Objects.requireNonNull(settings, "settings");
            this.id = settings.getId();
            this.key = settings.getKey();
            this.namespace = settings.getNamespace();
            this.value = settings.getValue();
        }

        @Nonnull
        public PluginSetting build() {
            return new PluginSetting(this);
        }

        @Nonnull
        public Builder key(String value) {
            this.key = value;
            return this.self();
        }

        @Nonnull
        public Builder namespace(String value) {
            this.namespace = value;
            return this.self();
        }

        @Nonnull
        public Builder value(String value) {
            this.value = value;
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

