/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.CustomPreconditions;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Immutable;

@Entity
@Table(name="plugin_state")
@Immutable
public class PluginState {
    @Column(name="enabled", nullable=false)
    private final boolean enabled;
    @Id
    @Column(name="name", nullable=false)
    private final String name;
    @Column(name="updated_timestamp", nullable=false)
    private final long timestamp;

    protected PluginState() {
        this.name = null;
        this.enabled = false;
        this.timestamp = 0L;
    }

    public PluginState(String name, boolean enabled, long timestamp) {
        CustomPreconditions.checkRequiredString((String)name, (int)255);
        this.name = name;
        this.enabled = enabled;
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginState that = (PluginState)o;
        return Objects.equals(this.getName(), that.getName());
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

