/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.validation.ConstraintNature;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.TrustedCreate;
import com.atlassian.bitbucket.validation.groups.TrustedUpdate;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.scope.Scopeable;
import com.atlassian.stash.internal.validation.ProjectKeyUnique;
import com.atlassian.stash.internal.validation.ProjectNameUnique;
import com.atlassian.stash.internal.validation.UnsupportedInApplicationMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@DiscriminatorColumn(name="project_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@ProjectKeyUnique(groups={Create.class, TrustedCreate.class, Update.class, TrustedUpdate.class}, payload={ConstraintNature.Conflict.class})
@ProjectNameUnique(groups={Create.class, TrustedCreate.class, Update.class, TrustedUpdate.class}, payload={ConstraintNature.Conflict.class})
@Table(name="project", indexes={@Index(name="idx_project_key", columnList="namespace,project_key"), @Index(name="idx_project_name", columnList="namespace,name"), @Index(name="idx_project_type", columnList="project_type")}, uniqueConstraints={@UniqueConstraint(name="uk_project_name", columnNames={"namespace", "name"}), @UniqueConstraint(name="uk_project_key", columnNames={"namespace", "project_key"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalProject
implements Project,
Initializable,
Scopeable {
    static final String TABLE = "project";
    private static final String ID_GEN = "projectIdGenerator";
    @Column(name="description")
    private final String description;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="projectIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="projectIdGenerator", table="id_sequence", pkColumnValue="project", allocationSize=20)
    private final int id;
    @Column(name="project_key")
    private final String key;
    @Column(name="name")
    private final String name;
    @Column(name="namespace")
    @OptionalString(size=128)
    @UnsupportedInApplicationMode(applicationMode={ApplicationMode.DEFAULT})
    @Type(type="com.atlassian.stash.internal.hibernate.NullPlaceholderStringType", parameters={@Parameter(name="placeholder", value="#")})
    private final String namespace;
    @Column(name="project_type", nullable=false, updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.project.ProjectType")})
    private final ProjectType type;

    protected InternalProject() {
        this.description = null;
        this.id = 0;
        this.key = null;
        this.name = null;
        this.namespace = null;
        this.type = ProjectType.NORMAL;
    }

    protected InternalProject(int id, String key, String name, String description, ProjectType type) {
        this.description = description;
        this.id = id;
        this.key = InternalProject.keyify(StringUtils.defaultString((String)key, (String)name));
        this.namespace = null;
        this.name = StringUtils.trimToNull((String)name);
        this.type = type;
    }

    @Nullable
    public static String keyify(@Nullable String key) {
        return StringUtils.upperCase((String)StringUtils.trimToNull((String)key), (Locale)Locale.ROOT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalProject) {
            InternalProject that = (InternalProject)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public ProjectType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public void initialize() {
    }

    @Override
    @Nonnull
    public Scope toScope() {
        return Scopes.project((Project)this);
    }

    public String toString() {
        return "Project{id=" + this.id + ", key='" + this.key + "', name='" + this.name + "'}";
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected int id;

        public AbstractBuilder() {
            this.id = 0;
        }

        public AbstractBuilder(@Nonnull Project project) {
            this.id = Objects.requireNonNull(project, InternalProject.TABLE).getId();
        }

        @Nonnull
        public B id(int value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

