/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalProject;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_project_alias")
@TableGenerator(allocationSize=20, pkColumnValue="bb_project_alias", name="projectAliasIdGenerator", table="id_sequence")
public class InternalProjectAlias
implements Initializable {
    public static final String ID_GEN = "projectAliasIdGenerator";
    public static final String TABLE = "bb_project_alias";
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="projectAliasIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="project_key")
    private final String key;
    @Type(type="com.atlassian.stash.internal.hibernate.NullPlaceholderStringType", parameters={@Parameter(name="placeholder", value="#")})
    @Column(name="namespace")
    @OptionalString
    private final String namespace;
    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=InternalProject.class)
    @JoinColumn(name="project_id", nullable=false)
    private InternalProject project;

    protected InternalProjectAlias() {
        this.createdDate = null;
        this.id = 0L;
        this.key = null;
        this.project = null;
        this.namespace = null;
    }

    private InternalProjectAlias(Builder builder) {
        this.createdDate = new Date();
        this.id = builder.id;
        this.key = InternalProject.keyify(builder.key);
        this.namespace = null;
        this.project = builder.project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalProjectAlias) {
            InternalProjectAlias that = (InternalProjectAlias)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    @RequiredString
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public InternalProject getProject() {
        return this.project;
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public void initialize() {
        this.project = HibernateUtils.initialize(this.getProject());
    }

    public static class Builder {
        private final InternalProject project;
        private final long id;
        private String key;

        public Builder(@Nonnull InternalProject project) {
            this.project = Objects.requireNonNull(project, "project");
            this.id = 0L;
            this.key = project.getKey();
        }

        @Nonnull
        public InternalProjectAlias build() {
            return new InternalProjectAlias(this);
        }

        @Nonnull
        public Builder key(@Nonnull String value) {
            this.key = Objects.requireNonNull(value, "key");
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

