/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.property;

import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.util.Map;
import java.util.Objects;

@MappedSuperclass
public abstract class AbstractPropertySupport
implements PropertySupport {
    @Transient
    private transient PropertyMap properties;

    protected AbstractPropertySupport() {
    }

    protected AbstractPropertySupport(@Nonnull PropertyBuilderSupport<?> builder) {
        this.properties = builder.properties.build();
    }

    @Nonnull
    public PropertyMap getProperties() {
        return (PropertyMap)MoreObjects.firstNonNull((Object)this.properties, (Object)PropertyMap.EMPTY);
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    protected boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    protected static abstract class PropertyBuilderSupport<B extends PropertyBuilderSupport<B>>
    extends BuilderSupport {
        private final PropertyMap.Builder properties = new PropertyMap.Builder();

        protected PropertyBuilderSupport() {
        }

        protected PropertyBuilderSupport(@Nonnull PropertySupport propertyHolder) {
            this.properties.properties((Map)propertyHolder.getProperties());
        }

        @Nonnull
        public B property(@Nonnull String key, @Nonnull Object value) {
            this.properties.property(key, value);
            return this.self();
        }

        @Nonnull
        public B properties(@Nonnull Map<String, Object> other) {
            this.properties.properties(other);
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

