/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.participant.InternalParticipable;
import com.atlassian.stash.internal.participant.ParticipableVisitor;
import com.atlassian.stash.internal.property.AbstractPropertySupport;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestPhase;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryScope;
import com.atlassian.stash.internal.repository.RepositoryScoped;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="sta_pull_request", indexes={@Index(name="idx_sta_pull_request_from", columnList="from_repository_id, from_branch_fqn"), @Index(name="idx_sta_pr_from_repo_update", columnList="from_repository_id, updated_timestamp"), @Index(name="idx_sta_pull_request_state", columnList="pr_state"), @Index(name="idx_sta_pull_request_to", columnList="to_repository_id, to_branch_fqn"), @Index(name="idx_sta_pr_to_repo_update", columnList="to_repository_id, updated_timestamp"), @Index(name="idx_sta_pr_update_ts", columnList="updated_timestamp"), @Index(name="idx_sta_pr_closed_ts", columnList="closed_timestamp"), @Index(name="idx_sta_pr_phase_state", columnList="phase, pr_state")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_pull_request_scoped_id", columnNames={"to_repository_id", "scoped_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalPullRequest
extends AbstractPropertySupport
implements Initializable,
InternalCommentable,
InternalParticipable<InternalPullRequestParticipant>,
InternalWatchable,
PullRequest,
RepositoryScoped {
    public static final String ID_GEN = "pullRequestIdGenerator";
    public static final String TABLE = "sta_pull_request";
    public static final long LOCK_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    @Column(name="closed_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date closedDate;
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="description")
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String description;
    @AssociationOverride(name="repository", foreignKey=@ForeignKey(name="fk_sta_pull_request_from_repo"), joinColumns={@JoinColumn(name="from_repository_id", nullable=false, updatable=false)})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="from_branch_name", nullable=false, updatable=false)), @AttributeOverride(name="hash", column=@Column(name="from_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="from_branch_fqn", nullable=false, updatable=false))})
    @Embedded
    private final InternalPullRequestRef fromRef;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pullRequestIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="sta_pull_request", name="pullRequestIdGenerator", table="id_sequence")
    private final long id;
    @Column(name="locked_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date lockedDate;
    @OneToMany(mappedBy="pullRequest", targetEntity=InternalPullRequestParticipant.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    private final Set<PullRequestParticipant> participants;
    @Column(name="phase", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.internal.pull.InternalPullRequestPhase")})
    private final InternalPullRequestPhase phase;
    @Column(name="rescoped_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date rescopedDate;
    @Column(name="scoped_id", nullable=false, updatable=false)
    private long scopedId;
    @Column(name="pr_state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.pull.PullRequestState")})
    private final PullRequestState state;
    @Column(name="title", nullable=false)
    private final String title;
    @AssociationOverride(name="repository", foreignKey=@ForeignKey(name="fk_sta_pull_request_to_repo"), joinColumns={@JoinColumn(name="to_repository_id", nullable=false, updatable=false)})
    @AttributeOverrides(value={@AttributeOverride(name="displayId", column=@Column(name="to_branch_name", nullable=false)), @AttributeOverride(name="hash", column=@Column(name="to_hash", nullable=false)), @AttributeOverride(name="id", column=@Column(name="to_branch_fqn", nullable=false))})
    @Embedded
    private final InternalPullRequestRef toRef;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;

    protected InternalPullRequest() {
        this.closedDate = null;
        this.updatedDate = null;
        this.rescopedDate = null;
        this.lockedDate = null;
        this.createdDate = null;
        this.title = null;
        this.description = null;
        this.toRef = null;
        this.fromRef = null;
        this.scopedId = 0L;
        this.id = 0L;
        this.participants = new HashSet<PullRequestParticipant>();
        this.phase = InternalPullRequestPhase.PUBLISHED;
        this.state = null;
        this.version = 0;
    }

    private InternalPullRequest(Builder builder) {
        super(builder);
        Date now = new Date();
        this.closedDate = builder.state == PullRequestState.OPEN ? null : builder.closedDate;
        this.createdDate = (Date)MoreObjects.firstNonNull((Object)builder.createdDate, (Object)now);
        this.description = builder.description;
        this.fromRef = builder.fromRef;
        this.id = builder.id;
        this.lockedDate = builder.lockedDate;
        this.participants = new HashSet<PullRequestParticipant>(builder.participants);
        this.phase = (InternalPullRequestPhase)((Object)MoreObjects.firstNonNull((Object)((Object)builder.phase), (Object)((Object)InternalPullRequestPhase.PUBLISHED)));
        this.scopedId = builder.scopedId;
        this.state = builder.state;
        this.title = builder.title;
        this.toRef = builder.toRef;
        this.updatedDate = (Date)MoreObjects.firstNonNull((Object)builder.updatedDate, (Object)now);
        this.rescopedDate = (Date)MoreObjects.firstNonNull((Object)builder.rescopedDate, (Object)this.updatedDate);
        this.version = builder.version;
    }

    @Override
    public <T> T accept(@Nonnull CommentableVisitor<T> visitor) {
        return (T)visitor.visit((PullRequest)this);
    }

    @Override
    public <T> T accept(@Nonnull ParticipableVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(@Nonnull WatchableVisitor<T> visitor) {
        return (T)visitor.visit((PullRequest)this);
    }

    @Override
    public void addParticipant(@Nonnull InternalPullRequestParticipant participant) {
        this.participants.add(participant);
    }

    @Nonnull
    public PullRequestParticipant getAuthor() {
        Set<PullRequestParticipant> authors = this.getParticipantsFilteredByRole(PullRequestRole.AUTHOR);
        if (authors.isEmpty()) {
            throw new IllegalStateException("Pull request author could not be found in its participants");
        }
        if (authors.size() > 1) {
            throw new IllegalStateException("Pull request has more than one author");
        }
        return authors.stream().findFirst().orElse(null);
    }

    public Date getClosedDate() {
        return this.closedDate == null ? null : new Date(this.closedDate.getTime());
    }

    @Nonnull
    public Date getCreatedDate() {
        return new Date(this.createdDate.getTime());
    }

    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public InternalPullRequestRef getFromRef() {
        return this.fromRef;
    }

    public long getGlobalId() {
        return this.id;
    }

    public long getId() {
        return this.getScopedId();
    }

    public Set<PullRequestParticipant> getAllParticipants() {
        return ImmutableSet.copyOf(this.participants);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalPullRequest) {
            InternalPullRequest that = (InternalPullRequest)o;
            return Objects.equals(this.getGlobalId(), that.getGlobalId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getGlobalId());
    }

    @Nonnull
    public Set<PullRequestParticipant> getParticipants() {
        return this.getParticipantsFilteredByRole(PullRequestRole.PARTICIPANT);
    }

    @Nonnull
    public Set<PullRequestParticipant> getReviewers() {
        return this.getParticipantsFilteredByRole(PullRequestRole.REVIEWER);
    }

    @Nonnull
    public Date getRescopedDate() {
        return this.rescopedDate;
    }

    @Override
    @Nonnull
    public InternalRepository getScopeRepository() {
        return this.getToRef().getRepository();
    }

    @Override
    @Nonnull
    public RepositoryScope getScope() {
        return RepositoryScope.PULL_REQUEST;
    }

    @Override
    public long getScopedId() {
        return this.scopedId;
    }

    @Nonnull
    public PullRequestState getState() {
        return this.state;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public InternalPullRequestRef getToRef() {
        return this.toRef;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return new Date(this.updatedDate.getTime());
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getFromRef());
        HibernateUtils.initialize(this.getToRef());
        for (PullRequestParticipant participant : this.getAllParticipants()) {
            Hibernate.initialize((Object)participant);
            Hibernate.initialize((Object)participant.getUser());
        }
    }

    public boolean isClosed() {
        return this.getState() != PullRequestState.OPEN;
    }

    public boolean isCrossRepository() {
        return this.getFromRef().getRepository().getId() != this.getToRef().getRepository().getId();
    }

    public boolean isDraft() {
        return this.phase == InternalPullRequestPhase.DRAFT;
    }

    public boolean isLocked() {
        return InternalPullRequest.isLockValid(this.lockedDate);
    }

    public boolean isOpen() {
        return this.getState() == PullRequestState.OPEN;
    }

    @Override
    public void removeParticipant(@Nonnull InternalPullRequestParticipant participant) {
        this.participants.remove(participant);
    }

    @Override
    public void setScopedId(long value) {
        if (this.scopedId != 0L) {
            throw new IllegalStateException("You cannot set the scoped ID after it's been initialized");
        }
        this.scopedId = value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("title", (Object)this.title).toString();
    }

    private static boolean isLockValid(Date lockedDate) {
        return lockedDate != null && System.currentTimeMillis() - lockedDate.getTime() < LOCK_TIMEOUT_MILLIS;
    }

    private Date getLockedDate() {
        return this.lockedDate;
    }

    private Set<PullRequestParticipant> getParticipantsFilteredByRole(PullRequestRole role) {
        return this.participants.stream().filter(role.getFilter()).collect(Collectors.toSet());
    }

    public static class Builder
    extends AbstractPropertySupport.PropertyBuilderSupport<Builder> {
        private final Set<PullRequestParticipant> participants;
        private Date closedDate;
        private Date createdDate;
        private String description;
        private InternalPullRequestRef fromRef;
        private long id;
        private Date lockedDate;
        private InternalPullRequestPhase phase;
        private Date rescopedDate;
        private long scopedId;
        private PullRequestState state;
        private String title;
        private InternalPullRequestRef toRef;
        private Date updatedDate;
        private int version;

        public Builder() {
            this.scopedId = 0L;
            this.id = 0L;
            this.participants = new HashSet<PullRequestParticipant>();
        }

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.closedDate = pullRequest.getClosedDate();
            this.createdDate = pullRequest.getCreatedDate();
            this.description = pullRequest.getDescription();
            this.fromRef = pullRequest.getFromRef();
            this.id = pullRequest.getGlobalId();
            this.participants = new HashSet<PullRequestParticipant>(pullRequest.getAllParticipants());
            this.phase = pullRequest.isDraft() ? InternalPullRequestPhase.DRAFT : InternalPullRequestPhase.PUBLISHED;
            this.lockedDate = pullRequest.getLockedDate();
            this.rescopedDate = pullRequest.getRescopedDate();
            this.scopedId = pullRequest.getScopedId();
            this.state = pullRequest.getState();
            this.title = pullRequest.getTitle();
            this.toRef = pullRequest.getToRef();
            this.updatedDate = pullRequest.getUpdatedDate();
            this.version = pullRequest.getVersion();
        }

        @Nonnull
        public InternalPullRequest build() {
            return new InternalPullRequest(this);
        }

        @Nonnull
        public Builder closedDate(@Nullable Date value) {
            this.closedDate = value;
            return this;
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = value;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public Builder draft(boolean value) {
            this.phase = value ? InternalPullRequestPhase.DRAFT : InternalPullRequestPhase.PUBLISHED;
            return this;
        }

        @Nonnull
        public Builder fromRef(@Nonnull InternalPullRequestRef value) {
            this.fromRef = value;
            return this;
        }

        @Nonnull
        public Builder globalId(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder locked(boolean value) {
            if (value) {
                if (!InternalPullRequest.isLockValid(this.lockedDate)) {
                    this.lockedDate = new Date();
                }
            } else {
                this.lockedDate = null;
            }
            return this;
        }

        @Nonnull
        public Builder participant(@Nullable PullRequestParticipant value) {
            return this.participants(value, new PullRequestParticipant[0]);
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<PullRequestParticipant> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this;
        }

        @Nonnull
        public Builder participants(@Nullable PullRequestParticipant value, PullRequestParticipant ... values) {
            Builder.addIf(Objects::nonNull, this.participants, (Object)value, (Object[])values);
            return this;
        }

        @Nonnull
        public Builder rescopedDate(@Nonnull Date value) {
            this.rescopedDate = value;
            return this;
        }

        @Nonnull
        public Builder scopedId(long value) {
            this.scopedId = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull PullRequestState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder title(@Nonnull String value) {
            this.title = Builder.checkNotBlank((String)value, (String)"title");
            return this;
        }

        @Nonnull
        public Builder toRef(@Nonnull InternalPullRequestRef value) {
            this.toRef = value;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = value;
            return this;
        }

        @Nonnull
        public Builder version(int value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

