/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestAutoMergeCancelledActivity;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="10")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_bb_pr_am_can_activity_id"))
@Table(name="bb_pr_am_cancelled_activity")
public class InternalPullRequestAutoMergeCancelledActivity
extends InternalPullRequestActivity
implements PullRequestAutoMergeCancelledActivity {
    public static final String TABLE = "bb_pr_am_cancelled_activity";
    @Column(name="cancelled_reason", nullable=false, updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.pull.AutoMergeCancelledReason")})
    private final AutoMergeCancelledReason cancelledReason;

    private InternalPullRequestAutoMergeCancelledActivity(Builder builder) {
        super(builder);
        this.cancelledReason = builder.cancelledReason;
    }

    protected InternalPullRequestAutoMergeCancelledActivity() {
        this.cancelledReason = null;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestAutoMergeCancelledActivity)this);
    }

    @Nonnull
    public AutoMergeCancelledReason getCancelledReason() {
        return this.cancelledReason;
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder, InternalPullRequestAutoMergeCancelledActivity> {
        private AutoMergeCancelledReason cancelledReason;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.action(PullRequestAction.AUTO_MERGE_CANCELLED);
        }

        @Override
        @Nonnull
        public InternalPullRequestAutoMergeCancelledActivity build() {
            return new InternalPullRequestAutoMergeCancelledActivity(this);
        }

        @Nonnull
        public Builder cancelledReason(@Nonnull AutoMergeCancelledReason value) {
            this.cancelledReason = Objects.requireNonNull(value, "value");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

