/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="2")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_bb_pr_com_act_id"))
@Table(name="bb_pr_comment_activity", indexes={@Index(name="idx_bb_pr_com_act_comment", columnList="comment_id")})
public class InternalPullRequestCommentActivity
extends InternalPullRequestActivity
implements PullRequestCommentActivity {
    public static final String TABLE = "bb_pr_comment_activity";
    @JoinColumn(name="comment_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_pr_com_act_comment"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalComment comment;
    @Column(name="comment_action", nullable=false, updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.comment.CommentAction")})
    private final CommentAction commentAction;
    @Transient
    private Diff diff;

    protected InternalPullRequestCommentActivity() {
        this.comment = null;
        this.commentAction = null;
    }

    private InternalPullRequestCommentActivity(Builder builder) {
        super(builder);
        this.comment = builder.comment;
        this.commentAction = builder.commentAction;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestCommentActivity)this);
    }

    @Nonnull
    public InternalComment getComment() {
        return this.comment;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return this.commentAction;
    }

    @Nonnull
    public Optional<Diff> getDiff() {
        return Optional.ofNullable(this.diff);
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getComment().getThread());
    }

    public void setDiff(Diff value) {
        if (this.diff != null) {
            throw new IllegalStateException("You cannot set the diff after it's been initialized");
        }
        this.diff = value;
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("commentAction", (Object)this.commentAction).add("comment", (Object)this.comment);
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder, InternalPullRequestCommentActivity> {
        private InternalComment comment;
        private CommentAction commentAction;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.action(PullRequestAction.COMMENTED);
        }

        public Builder(@Nonnull InternalPullRequestCommentActivity activity) {
            super(activity);
            this.comment = activity.getComment();
            this.commentAction = activity.getCommentAction();
        }

        @Override
        @Nonnull
        public InternalPullRequestCommentActivity build() {
            return new InternalPullRequestCommentActivity(this);
        }

        @Nonnull
        public Builder comment(@Nonnull InternalComment value) {
            this.comment = Objects.requireNonNull(value, "comment");
            return this.self();
        }

        @Nonnull
        public Builder commentAction(@Nonnull CommentAction value) {
            this.commentAction = Objects.requireNonNull(value, "commentAction");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

