/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Objects;
import org.hibernate.annotations.Immutable;

@Entity
@Table(name="bb_pr_commit", indexes={@Index(name="idx_bb_pr_commit_commit_id", columnList="commit_id")})
@IdClass(value=PK.class)
@Immutable
public class InternalPullRequestCommit {
    @Id
    @Column(name="commit_id")
    @RequiredString(minimumSize=40, size=40)
    private final String commitId;
    @Id
    @JoinColumn(name="pr_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_pr_commit_pr"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;

    protected InternalPullRequestCommit() {
        this.commitId = null;
        this.pullRequest = null;
    }

    private InternalPullRequestCommit(Builder builder) {
        this.commitId = builder.commitId;
        this.pullRequest = builder.pullRequest;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    public String toString() {
        return "InternalPullRequestCommit{commitId='" + this.getCommitId() + "', pullRequest=" + String.valueOf(this.getPullRequest()) + "}";
    }

    public static final class Builder
    extends BuilderSupport {
        private final String commitId;
        private final InternalPullRequest pullRequest;

        public Builder(@Nonnull InternalPullRequestCommit prCommit) {
            this.commitId = prCommit.getCommitId();
            this.pullRequest = prCommit.getPullRequest();
        }

        public Builder(@Nonnull String commitId, @Nonnull InternalPullRequest pullRequest) {
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commitId");
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        }

        @Nonnull
        public InternalPullRequestCommit build() {
            return new InternalPullRequestCommit(this);
        }
    }

    public static class PK
    implements Serializable {
        private final String commitId;
        private final long pullRequest;

        public PK() {
            this(null, 0L);
        }

        public PK(@Nonnull String commitId, long pullRequest) {
            this.commitId = commitId;
            this.pullRequest = pullRequest;
        }

        public PK(@Nonnull InternalPullRequestCommit pullRequestCommit) {
            this(pullRequestCommit.getCommitId(), pullRequestCommit.getPullRequest().getGlobalId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            return this.pullRequest == pk.pullRequest && Objects.equals(this.commitId, pk.commitId);
        }

        public int hashCode() {
            return Objects.hash(this.commitId, this.pullRequest);
        }

        public String toString() {
            return "InternalPullRequestCommit.PK{commitId='" + this.commitId + "', pullRequest=" + this.pullRequest + "}";
        }
    }
}

