/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.apache.commons.lang3.StringUtils;

@DiscriminatorValue(value="3")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_sta_pr_mrg_act_id"))
@Table(name="sta_pr_merge_activity")
public class InternalPullRequestMergeActivity
extends InternalPullRequestActivity
implements PullRequestMergeActivity {
    public static final String TABLE = "sta_pr_merge_activity";
    @Column(name="is_auto_merge", updatable=false)
    private final Boolean autoMerge;
    @Column(name="hash", length=40, updatable=false)
    private final String hash;
    @Transient
    private Commit commit;

    protected InternalPullRequestMergeActivity() {
        this.autoMerge = false;
        this.hash = null;
    }

    private InternalPullRequestMergeActivity(Builder builder) {
        super(builder);
        this.autoMerge = builder.autoMerge;
        this.hash = builder.hash;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestMergeActivity)this);
    }

    public Commit getCommit() {
        return this.commit;
    }

    public String getCommitId() {
        return this.getHash();
    }

    @OptionalString(minimumSize=40, size=40)
    public String getHash() {
        return this.hash;
    }

    public boolean isAutoMerge() {
        return this.autoMerge != null && this.autoMerge != false;
    }

    public boolean isRemote() {
        return this.getHash() == null;
    }

    public void setCommit(Commit value) {
        if (this.commit != null) {
            throw new IllegalStateException("You cannot reset the commit after it's been initialized");
        }
        this.commit = value;
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder, InternalPullRequestMergeActivity> {
        private boolean autoMerge;
        private String hash;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.action(PullRequestAction.MERGED);
        }

        public Builder(@Nonnull InternalPullRequestMergeActivity activity) {
            super(activity);
            this.autoMerge = activity.isAutoMerge();
            this.hash = activity.getHash();
        }

        @Nonnull
        public Builder autoMerge(boolean autoMerge) {
            this.autoMerge = autoMerge;
            return this.self();
        }

        @Override
        @Nonnull
        public InternalPullRequestMergeActivity build() {
            return new InternalPullRequestMergeActivity(this);
        }

        @Nonnull
        public Builder hash(String value) {
            this.hash = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

