/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.participant.InternalAbstractParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="sta_pr_participant", indexes={@Index(name="idx_sta_pr_participant_pr", columnList="pr_id"), @Index(name="idx_sta_pr_participant_user", columnList="user_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_pr_participant_pr_user", columnNames={"pr_id", "user_id"})})
@TableGenerator(allocationSize=5, pkColumnValue="sta_pr_participant", name="pullRequestParticipantIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalPullRequestParticipant
extends InternalAbstractParticipant<InternalPullRequestParticipant>
implements PullRequestParticipant {
    public static final String ID_GEN = "pullRequestParticipantIdGenerator";
    public static final String TABLE = "sta_pr_participant";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pullRequestParticipantIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="last_reviewed_commit", length=40)
    @OptionalString(minimumSize=40, size=40)
    private final String lastReviewedCommit;
    @JoinColumn(name="pr_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_participant_pr"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;
    @Column(name="pr_role", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.pull.PullRequestRole")})
    private final PullRequestRole role;
    @Column(name="participant_status", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.pull.PullRequestParticipantStatus")})
    private final PullRequestParticipantStatus status;

    protected InternalPullRequestParticipant() {
        this.id = 0L;
        this.lastReviewedCommit = null;
        this.pullRequest = null;
        this.role = null;
        this.status = PullRequestParticipantStatus.UNAPPROVED;
    }

    private InternalPullRequestParticipant(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.lastReviewedCommit = builder.lastReviewedCommit;
        this.pullRequest = builder.pullRequest;
        this.role = builder.role;
        this.status = builder.status;
    }

    public int compareTo(@Nonnull PullRequestParticipant other) {
        if (this.getStatus().equals((Object)other.getStatus())) {
            return this.getUser().getDisplayName().compareTo(other.getUser().getDisplayName());
        }
        return other.getStatus().getWeight() - this.getStatus().getWeight();
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalPullRequest getEntity() {
        return this.getPullRequest();
    }

    @Nullable
    public String getLastReviewedCommit() {
        return this.lastReviewedCommit;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public PullRequestRole getRole() {
        return this.role;
    }

    @Nonnull
    public PullRequestParticipantStatus getStatus() {
        return this.status;
    }

    @Override
    @Nonnull
    public InternalApplicationUser getUser() {
        return super.getUser();
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getPullRequest());
        super.initialize();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lastReviewedCommit", (Object)this.lastReviewedCommit).add("role", (Object)this.role).add("status", (Object)this.status).add("user", (Object)this.getUser()).toString();
    }

    public boolean isApproved() {
        return this.status == PullRequestParticipantStatus.APPROVED;
    }

    public static class Builder
    extends InternalAbstractParticipant.AbstractParticipantBuilder<Builder, InternalPullRequestParticipant> {
        private final InternalPullRequest pullRequest;
        private long id;
        private String lastReviewedCommit;
        private PullRequestRole role;
        private PullRequestParticipantStatus status;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            this.id = 0L;
            this.lastReviewedCommit = null;
            this.role = PullRequestRole.PARTICIPANT;
            this.status = PullRequestParticipantStatus.UNAPPROVED;
        }

        public Builder(@Nonnull InternalPullRequestParticipant participant) {
            super(participant);
            this.id = participant.getId();
            this.lastReviewedCommit = participant.getLastReviewedCommit();
            this.pullRequest = participant.getPullRequest();
            this.role = participant.getRole();
            this.status = participant.getStatus();
        }

        @Nonnull
        public InternalPullRequestParticipant build() {
            return new InternalPullRequestParticipant(this);
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public Builder lastReviewedCommit(@Nonnull String value) {
            this.lastReviewedCommit = Objects.requireNonNull(value, "lastReviewedCommit");
            return this.self();
        }

        @Nonnull
        public Builder role(@Nonnull PullRequestRole value) {
            this.role = Objects.requireNonNull(value, "role");
            return this.self();
        }

        @Nonnull
        public Builder status(@Nonnull PullRequestParticipantStatus value) {
            this.status = Objects.requireNonNull(value, "status");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

