/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.pull.SimpleRescopeDetails;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeCommit;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@DiscriminatorValue(value="4")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_sta_pr_rescope_act_id"))
@Table(name="sta_pr_rescope_activity")
public class InternalPullRequestRescopeActivity
extends InternalPullRequestActivity
implements PullRequestRescopeActivity {
    public static final String TABLE = "sta_pr_rescope_activity";
    @Transient
    private SimpleRescopeDetails added;
    @CollectionTable(name="sta_pr_rescope_commit", joinColumns={@JoinColumn(name="activity_id", nullable=false)})
    @ElementCollection
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<InternalPullRequestRescopeCommit> commits;
    @Column(name="from_hash", nullable=false, length=40, updatable=false)
    @RequiredString(size=40)
    private final String fromHash;
    @Column(name="prev_from_hash", nullable=false, length=40, updatable=false)
    @RequiredString(size=40)
    private final String previousFromHash;
    @Column(name="prev_to_hash", nullable=false, length=40, updatable=false)
    @RequiredString(size=40)
    private final String previousToHash;
    @Transient
    private SimpleRescopeDetails removed;
    @Column(name="to_hash", nullable=false, length=40, updatable=false)
    @RequiredString(size=40)
    private final String toHash;
    @Column(name="commits_added")
    private final Integer totalAdded;
    @Column(name="commits_removed")
    private final Integer totalRemoved;

    protected InternalPullRequestRescopeActivity() {
        this.added = this.removed = SimpleRescopeDetails.EMPTY;
        this.commits = Sets.newHashSet();
        this.toHash = null;
        this.previousToHash = null;
        this.previousFromHash = null;
        this.fromHash = null;
        this.totalRemoved = null;
        this.totalAdded = null;
    }

    private InternalPullRequestRescopeActivity(Builder builder) {
        super(builder);
        this.commits = builder.commits.build();
        this.fromHash = builder.fromHash;
        this.previousFromHash = builder.previousFromHash;
        this.previousToHash = builder.previousToHash;
        this.toHash = builder.toHash;
        this.totalAdded = builder.totalAdded;
        this.totalRemoved = builder.totalRemoved;
        this.added = this.removed = SimpleRescopeDetails.EMPTY;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestRescopeActivity)this);
    }

    @Nonnull
    public RescopeDetails getAdded() {
        return this.added;
    }

    public Set<InternalPullRequestRescopeCommit> getCommits() {
        return this.commits;
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return this.previousToHash;
    }

    @Nonnull
    public RescopeDetails getRemoved() {
        return this.removed;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public int getTotalAdded() {
        return this.totalAdded == null ? 0 : this.totalAdded;
    }

    public int getTotalRemoved() {
        return this.totalRemoved == null ? 0 : this.totalRemoved;
    }

    @Override
    public void initialize() {
        super.initialize();
        Hibernate.initialize(this.getCommits());
    }

    public boolean isPrecalculated() {
        return this.totalAdded != null;
    }

    public void setAdded(SimpleRescopeDetails value) {
        if (this.added != SimpleRescopeDetails.EMPTY) {
            throw new IllegalStateException("You cannot set the added details after they've been initialized");
        }
        this.added = value;
    }

    public void setRemoved(SimpleRescopeDetails value) {
        if (this.removed != SimpleRescopeDetails.EMPTY) {
            throw new IllegalStateException("You cannot set the removed details after they've been initialized");
        }
        this.removed = value;
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder, InternalPullRequestRescopeActivity> {
        private final ImmutableSet.Builder<InternalPullRequestRescopeCommit> commits = ImmutableSet.builder();
        private String fromHash;
        private String previousFromHash;
        private String previousToHash;
        private String toHash;
        private Integer totalAdded;
        private Integer totalRemoved;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.action(PullRequestAction.RESCOPED);
        }

        public Builder(@Nonnull InternalPullRequestRescopeActivity activity) {
            super(activity);
            this.fromHash = activity.getFromHash();
            this.previousFromHash = activity.getPreviousFromHash();
            this.previousToHash = activity.getPreviousToHash();
            this.toHash = activity.getToHash();
        }

        @Override
        @Nonnull
        public InternalPullRequestRescopeActivity build() {
            return new InternalPullRequestRescopeActivity(this);
        }

        @Nonnull
        public Builder commit(InternalPullRequestRescopeCommit value) {
            return this.commits(value, new InternalPullRequestRescopeCommit[0]);
        }

        @Nonnull
        public Builder commits(InternalPullRequestRescopeCommit value, InternalPullRequestRescopeCommit ... values) {
            this.commits.add((Object)value).add((Object[])values);
            return this.self();
        }

        @Nonnull
        public Builder commits(Iterable<InternalPullRequestRescopeCommit> value) {
            this.commits.addAll(value);
            return this.self();
        }

        @Nonnull
        public Builder fromHash(@Nonnull String value) {
            this.fromHash = Builder.checkNotBlank((String)value, (String)"fromHash");
            return this.self();
        }

        @Nonnull
        public Builder previousFromHash(@Nonnull String value) {
            this.previousFromHash = Builder.checkNotBlank((String)value, (String)"previousFromHash");
            return this.self();
        }

        @Nonnull
        public Builder previousToHash(String value) {
            this.previousToHash = Builder.checkNotBlank((String)value, (String)"previousToHash");
            return this.self();
        }

        @Nonnull
        public Builder toHash(String value) {
            this.toHash = Builder.checkNotBlank((String)value, (String)"toHash");
            return this.self();
        }

        @Nonnull
        public Builder totalAdded(int value) {
            this.totalAdded = value;
            return this.self();
        }

        @Nonnull
        public Builder totalRemoved(int value) {
            this.totalRemoved = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

