/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class InternalPullRequestRescopeCommit {
    @Column(name="action", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.stash.internal.pull.PullRequestRescopeCommitAction")})
    private final PullRequestRescopeCommitAction action;
    @Column(name="changeset_id", nullable=false, length=40)
    @RequiredString(size=40)
    private final String commitId;

    protected InternalPullRequestRescopeCommit() {
        this.action = null;
        this.commitId = null;
    }

    private InternalPullRequestRescopeCommit(String commitId, PullRequestRescopeCommitAction action) {
        this.action = action;
        this.commitId = commitId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InternalPullRequestRescopeCommit) {
            InternalPullRequestRescopeCommit c = (InternalPullRequestRescopeCommit)o;
            return Objects.equals(this.getCommitId(), c.getCommitId());
        }
        return false;
    }

    @Nonnull
    public PullRequestRescopeCommitAction getAction() {
        return this.action;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public int hashCode() {
        return Objects.hashCode(this.getCommitId());
    }

    public static class Builder {
        private PullRequestRescopeCommitAction action;
        private String commitId;

        @Nonnull
        public Builder action(@Nonnull PullRequestRescopeCommitAction value) {
            this.action = Objects.requireNonNull(value, "action");
            return this;
        }

        @Nonnull
        public InternalPullRequestRescopeCommit build() {
            return new InternalPullRequestRescopeCommit(this.commitId, this.action);
        }

        @Nonnull
        public Builder commitId(@Nonnull String value) {
            this.commitId = Objects.requireNonNull(value, "commitId");
            return this;
        }
    }
}

