/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@DiscriminatorValue(value="7")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_bb_pr_reviewer_act_id"))
@Table(name="bb_pr_reviewer_upd_activity")
public class InternalPullRequestReviewersUpdatedActivity
extends InternalPullRequestActivity
implements PullRequestReviewersUpdatedActivity {
    public static final String TABLE = "bb_pr_reviewer_upd_activity";
    @ManyToMany(targetEntity=InternalApplicationUser.class)
    @JoinTable(name="bb_pr_reviewer_added", joinColumns={@JoinColumn(name="activity_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="user_id", nullable=false)}, foreignKey=@ForeignKey(name="fk_bb_pr_reviewer_added_act"), inverseForeignKey=@ForeignKey(name="fk_bb_pr_reviewer_added_user"))
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private Set<ApplicationUser> addedReviewers;
    @ManyToMany(targetEntity=InternalApplicationUser.class)
    @JoinTable(name="bb_pr_reviewer_removed", joinColumns={@JoinColumn(name="activity_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="user_id", nullable=false)}, foreignKey=@ForeignKey(name="fk_bb_pr_reviewer_removed_act"), inverseForeignKey=@ForeignKey(name="fk_bb_pr_reviewer_removed_user"))
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private Set<ApplicationUser> removedReviewers;

    protected InternalPullRequestReviewersUpdatedActivity() {
        this.addedReviewers = Collections.emptySet();
        this.removedReviewers = Collections.emptySet();
    }

    private InternalPullRequestReviewersUpdatedActivity(Builder builder) {
        super(builder);
        this.addedReviewers = builder.addedReviewers.build();
        this.removedReviewers = builder.removedReviewers.build();
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestReviewersUpdatedActivity)this);
    }

    @Nonnull
    public Set<ApplicationUser> getAddedReviewers() {
        return this.addedReviewers;
    }

    @Nonnull
    public Set<ApplicationUser> getRemovedReviewers() {
        return this.removedReviewers;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addedReviewers = HibernateUtils.initializeSet(this.getAddedReviewers());
        this.removedReviewers = HibernateUtils.initializeSet(this.getRemovedReviewers());
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("addedReviewers", this.addedReviewers).add("removedReviewers", this.removedReviewers);
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder, InternalPullRequestReviewersUpdatedActivity> {
        private final ImmutableSet.Builder<ApplicationUser> addedReviewers;
        private final ImmutableSet.Builder<ApplicationUser> removedReviewers;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.action(PullRequestAction.UPDATED);
            this.addedReviewers = ImmutableSet.builder();
            this.removedReviewers = ImmutableSet.builder();
        }

        @Override
        @Nonnull
        public InternalPullRequestReviewersUpdatedActivity build() {
            return new InternalPullRequestReviewersUpdatedActivity(this);
        }

        @Nonnull
        public Builder addedReviewers(@Nonnull Iterable<ApplicationUser> values) {
            Builder.addIf(Objects::nonNull, this.addedReviewers, values);
            return this.self();
        }

        @Nonnull
        public Builder removedReviewers(@Nonnull Iterable<ApplicationUser> values) {
            Builder.addIf(Objects::nonNull, this.removedReviewers, values);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

