/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.dmz.pull.PullRequestSummary;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.pull.InternalPullRequestRef;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class InternalPullRequestSummary
implements PullRequestSummary,
Initializable {
    private final InternalPullRequestRef fromRef;
    private final long globalId;
    private final String mergeHash;
    private final long scopedId;
    private final PullRequestState state;
    private final String title;
    private final InternalPullRequestRef toRef;
    private final Date updatedDate;

    private InternalPullRequestSummary(Builder builder) {
        this.fromRef = builder.fromRef;
        this.globalId = builder.globalId;
        this.mergeHash = builder.mergeHash;
        this.scopedId = builder.scopedId;
        this.state = builder.state;
        this.title = builder.title;
        this.toRef = builder.toRef;
        this.updatedDate = builder.updatedDate;
    }

    @Nonnull
    public InternalPullRequestRef getFromRef() {
        return this.fromRef;
    }

    public long getGlobalId() {
        return this.globalId;
    }

    public long getId() {
        return this.getScopedId();
    }

    @Nonnull
    public Optional<String> getMergeHash() {
        return Optional.ofNullable(this.mergeHash);
    }

    public long getScopedId() {
        return this.scopedId;
    }

    @Nonnull
    public Optional<PullRequestState> getState() {
        return Optional.ofNullable(this.state);
    }

    @Nonnull
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Nonnull
    public InternalPullRequestRef getToRef() {
        return this.toRef;
    }

    @Nonnull
    public Optional<Date> getUpdatedDate() {
        return Optional.ofNullable(this.updatedDate).map(date -> new Date(date.getTime()));
    }

    @Override
    public void initialize() {
        this.getFromRef().initialize();
        this.getToRef().initialize();
    }

    public static class Builder {
        private final InternalPullRequestRef fromRef;
        private final long globalId;
        private final long scopedId;
        private final InternalPullRequestRef toRef;
        private String mergeHash;
        private PullRequestState state;
        private String title;
        private Date updatedDate;

        public Builder(long globalId, long scopedId, @Nonnull InternalPullRequestRef fromRef, @Nonnull InternalPullRequestRef toRef) {
            this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
            this.globalId = globalId;
            this.scopedId = scopedId;
            this.toRef = Objects.requireNonNull(toRef, "toRef");
        }

        @Nonnull
        public InternalPullRequestSummary build() {
            return new InternalPullRequestSummary(this);
        }

        @Nonnull
        public Builder mergeHash(@Nullable String value) {
            this.mergeHash = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder title(@Nullable String value) {
            this.title = value;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nullable Date value) {
            this.updatedDate = value;
            return this;
        }
    }
}

