/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.repository.InternalRefChange;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="sta_pr_rescope_request", indexes={@Index(name="idx_sta_pr_rescope_req_repo", columnList="repo_id")})
@TableGenerator(allocationSize=43, pkColumnValue="sta_pr_rescope_request", name="rescopeRequestIdGenerator", table="id_sequence")
public class InternalRescopeRequest
implements Initializable,
Comparable<InternalRescopeRequest> {
    public static final String ID_GEN = "rescopeRequestIdGenerator";
    static final String TABLE = "sta_pr_rescope_request";
    private static final Comparator<InternalRescopeRequest> COMPARATOR = Comparator.comparing(InternalRescopeRequest::getCreatedDate).thenComparing(InternalRescopeRequest::getId);
    private static final Logger log = LoggerFactory.getLogger(InternalRescopeRequest.class);
    @Column(name="created_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="rescopeRequestIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @CollectionTable(name="sta_pr_rescope_request_change", joinColumns={@JoinColumn(name="request_id", nullable=false)})
    @ElementCollection(targetClass=InternalRefChange.class)
    private Set<RefChange> refChanges;
    @JoinColumn(name="repo_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_repo"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_rescope_req_user"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;

    protected InternalRescopeRequest() {
        this.createdDate = null;
        this.id = 0L;
    }

    public InternalRescopeRequest(Builder builder) {
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.refChanges = builder.refChanges.build();
        this.repository = builder.repository;
        this.user = builder.user;
    }

    @Override
    public int compareTo(@Nonnull InternalRescopeRequest o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalRescopeRequest that = (InternalRescopeRequest)o;
        return this.id == that.id;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Set<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
        this.user = HibernateUtils.initialize(this.getUser());
        Hibernate.initialize(this.refChanges);
    }

    @Nullable
    private static InternalRefChange maybeTransform(@Nullable RefChange change) {
        if (change == null) {
            return null;
        }
        if (change.getRef() == null || change.getType() == null || StringUtils.isBlank((CharSequence)change.getRef().getId()) || change.getFromHash() != null && change.getFromHash().length() > 40 || change.getToHash() != null && change.getToHash().length() > 40) {
            MinimalRef ref = change.getRef();
            log.debug("Failed to transform RefChange: (refId: {}, fromHash: {}, toHash:{}, type: {})", new Object[]{ref == null ? null : ref.getId(), change.getFromHash(), change.getToHash(), change.getType()});
            return null;
        }
        if (change.getRef().getType() == StandardRefType.TAG || change.getType() == RefChangeType.ADD) {
            return null;
        }
        return new InternalRefChange(change);
    }

    public static class Builder {
        private final ImmutableSet.Builder<RefChange> refChanges = ImmutableSet.builder();
        private final InternalRepository repository;
        private final InternalApplicationUser user;
        private Date createdDate;
        private long id;

        public Builder(@Nonnull InternalRescopeRequest request) {
            Objects.requireNonNull(request, "request");
            this.createdDate = Objects.requireNonNull(request.getCreatedDate(), "request.createdDate");
            this.id = request.getId();
            this.repository = Objects.requireNonNull(request.getRepository(), "request.repository");
            this.user = Objects.requireNonNull(request.getUser(), "request.user");
            this.refChanges.addAll((Iterable)Objects.requireNonNull(request.getRefChanges(), "request.refChanges"));
        }

        public Builder(@Nonnull InternalRepository repository, @Nonnull InternalApplicationUser user) {
            this.createdDate = new Date();
            this.id = 0L;
            this.repository = Objects.requireNonNull(repository, "repository");
            this.user = Objects.requireNonNull(user, "user");
        }

        @Nonnull
        public Builder branchIds(@Nonnull Collection<String> values) {
            Objects.requireNonNull(values, "branchIds").stream().filter(StringUtils::isNotBlank).map(InternalRefChange::new).forEach(arg_0 -> this.refChanges.add(arg_0));
            return this.self();
        }

        @Nonnull
        public InternalRescopeRequest build() {
            return new InternalRescopeRequest(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = Objects.requireNonNull(value, "createdDate");
            return this.self();
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public Builder refChanges(@Nonnull Collection<? extends RefChange> values) {
            Objects.requireNonNull(values, "refChanges").stream().map(InternalRescopeRequest::maybeTransform).filter(Objects::nonNull).forEach(arg_0 -> this.refChanges.add(arg_0));
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

