/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplateVariable;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.stereotype.Component;

@Component
public class PullRequestCommitMessageTemplateVariableSubstitutor {
    private static final Map<String, Function<PullRequest, String>> VARIABLE_NAME_TO_RESOLVE_FUNCTION = PullRequestCommitMessageTemplateVariableSubstitutor.buildNameToResovlerMap();

    @Nonnull
    public String substituteVariables(@Nonnull String template, @Nonnull PullRequest source) {
        Objects.requireNonNull(template, "template");
        Objects.requireNonNull(source, "source");
        HashMap values = new HashMap();
        StringSubstitutor substitutor = new StringSubstitutor(variable -> values.computeIfAbsent(variable.toLowerCase(Locale.ROOT), key -> {
            Function<PullRequest, String> resolver = VARIABLE_NAME_TO_RESOLVE_FUNCTION.get(key);
            if (resolver == null) {
                return null;
            }
            return resolver.apply(source);
        })).setDisableSubstitutionInValues(true).setEnableUndefinedVariableException(false).setVariablePrefix("${").setVariableSuffix("}").setEscapeChar('\\');
        return substitutor.replace(template);
    }

    private static Map<String, Function<PullRequest, String>> buildNameToResovlerMap() {
        return ImmutableMap.builder().put((Object)PullRequestCommitMessageTemplateVariable.APPROVERS.getName().toLowerCase(Locale.ROOT), PullRequestCommitMessageTemplateVariableSubstitutor::resolveApprovers).put((Object)PullRequestCommitMessageTemplateVariable.ID.getName().toLowerCase(Locale.ROOT), pr -> Long.toString(pr.getId())).put((Object)PullRequestCommitMessageTemplateVariable.CROSS_REPO_PR_REPO.getName().toLowerCase(Locale.ROOT), PullRequestCommitMessageTemplateVariableSubstitutor::resolveCrossReopPrRepo).put((Object)PullRequestCommitMessageTemplateVariable.DESCRIPTION.getName().toLowerCase(Locale.ROOT), pr -> pr.getDescription() == null ? "" : pr.getDescription()).put((Object)PullRequestCommitMessageTemplateVariable.FROM_PROJECT_KEY.getName().toLowerCase(Locale.ROOT), pr -> pr.getFromRef().getRepository().getProject().getKey()).put((Object)PullRequestCommitMessageTemplateVariable.FROM_REF_NAME.getName().toLowerCase(Locale.ROOT), pr -> pr.getFromRef().getDisplayId()).put((Object)PullRequestCommitMessageTemplateVariable.FROM_REPO_SLUG.getName().toLowerCase(Locale.ROOT), pr -> pr.getFromRef().getRepository().getSlug()).put((Object)PullRequestCommitMessageTemplateVariable.TITLE.getName().toLowerCase(Locale.ROOT), PullRequest::getTitle).put((Object)PullRequestCommitMessageTemplateVariable.TO_PROJECT_KEY.getName().toLowerCase(Locale.ROOT), pr -> pr.getToRef().getRepository().getProject().getKey()).put((Object)PullRequestCommitMessageTemplateVariable.TO_REF_NAME.getName().toLowerCase(Locale.ROOT), pr -> pr.getToRef().getDisplayId()).put((Object)PullRequestCommitMessageTemplateVariable.TO_REPO_SLUG.getName().toLowerCase(Locale.ROOT), pr -> pr.getToRef().getRepository().getSlug()).build();
    }

    private static String resolveApprovers(PullRequest pr) {
        return pr.getReviewers().stream().filter(PullRequestParticipant::isApproved).map(participant -> participant.getUser().getDisplayName()).collect(Collectors.joining(", "));
    }

    private static String resolveCrossReopPrRepo(PullRequest pr) {
        return pr.isCrossRepository() ? pr.getFromRef().getRepository().getProject().getKey() + "/" + pr.getFromRef().getRepository().getSlug() + ":" : "";
    }
}

