/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SimplePullRequestCommitMessageTemplate
implements PullRequestCommitMessageTemplate {
    private final String body;
    private final String title;

    private SimplePullRequestCommitMessageTemplate(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePullRequestCommitMessageTemplate that = (SimplePullRequestCommitMessageTemplate)o;
        return Objects.equals(this.body, that.body) && Objects.equals(this.title, that.title);
    }

    @Nonnull
    public String getBody() {
        return this.body;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        return Objects.hash(this.body, this.title);
    }

    public static class Builder {
        private final String title;
        private String body;

        public Builder(@Nonnull String title) {
            this.title = StringUtils.trimToEmpty((String)Objects.requireNonNull(title, "title"));
            if (title.isEmpty()) {
                throw new IllegalArgumentException("A title must be provided");
            }
        }

        @Nonnull
        public Builder body(@Nonnull String value) {
            this.body = Objects.requireNonNull(value);
            return this;
        }

        @Nonnull
        public PullRequestCommitMessageTemplate build() {
            this.body = StringUtils.trimToEmpty((String)this.body);
            return new SimplePullRequestCommitMessageTemplate(this);
        }
    }
}

