/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.pull.automerge.AutoMergeRequest;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_auto_merge_request", indexes={@Index(name="idx_bb_auto_merge_request_user", columnList="user_id"), @Index(name="idx_bb_auto_merge_request_crtd", columnList="created_timestamp")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalAutoMergeRequest
implements Initializable,
AutoMergeRequest {
    public static final String TABLE = "bb_auto_merge_request";
    @Column(name="auto_subject", nullable=false, updatable=false)
    private final boolean autoSubject;
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="from_hash", nullable=false, length=40, updatable=false)
    @RequiredString(minimumSize=40, size=40)
    private final String fromHash;
    @Column(name="message", updatable=false)
    @Lob
    @OptionalString(size=0x7FFFFFFF)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String message;
    @Id
    @Column(name="pr_id", nullable=false, unique=true, updatable=false)
    private final long pullRequestId;
    @Column(name="strategy_id", updatable=false)
    @OptionalString
    private final String strategyId;
    @Column(name="to_ref_id", nullable=false, length=1024, updatable=false)
    @RequiredString(size=1024)
    private final String toRefId;
    @JoinColumn(name="pr_id", foreignKey=@ForeignKey(name="fk_bb_auto_merge_req_pr"), nullable=false, updatable=false)
    @OneToOne(fetch=FetchType.LAZY, optional=false)
    private InternalPullRequest pullRequest;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_auto_merge_req_user"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;

    protected InternalAutoMergeRequest() {
        this.autoSubject = false;
        this.createdDate = null;
        this.fromHash = null;
        this.message = null;
        this.pullRequestId = 0L;
        this.strategyId = null;
        this.toRefId = null;
    }

    private InternalAutoMergeRequest(Builder builder) {
        this.autoSubject = builder.autoSubject;
        this.user = Objects.requireNonNull(builder.user, "user");
        this.createdDate = (Date)ObjectUtils.firstNonNull((Object[])new Date[]{builder.createdDate, new Date()});
        this.fromHash = Objects.requireNonNull(builder.pullRequest, "pullRequest").getFromRef().getLatestCommit();
        this.message = builder.message;
        this.pullRequestId = builder.pullRequest.getGlobalId();
        this.pullRequest = builder.pullRequest;
        this.strategyId = builder.strategyId;
        this.toRefId = builder.pullRequest.getToRef().getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalAutoMergeRequest that = (InternalAutoMergeRequest)o;
        return this.autoSubject == that.autoSubject && this.pullRequestId == that.pullRequestId && this.createdDate.equals(that.createdDate) && this.fromHash.equals(that.fromHash) && Objects.equals(this.message, that.message) && Objects.equals(this.strategyId, that.strategyId) && this.toRefId.equals(that.toRefId) && this.user.equals(that.user) && this.pullRequest.equals(that.pullRequest);
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    public long getId() {
        return this.pullRequestId;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    public int getRepositoryId() {
        return this.pullRequest.getToRef().getRepository().getId();
    }

    @Nullable
    public String getStrategyId() {
        return this.strategyId;
    }

    @Nonnull
    public String getToRefId() {
        return this.toRefId;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    public int hashCode() {
        return Objects.hash(this.autoSubject, this.createdDate, this.fromHash, this.message, this.pullRequestId, this.strategyId, this.toRefId, this.user, this.pullRequest);
    }

    @Override
    public void initialize() {
        this.pullRequest = HibernateUtils.initialize(this.pullRequest);
        this.user = HibernateUtils.initialize(this.user);
    }

    public boolean isAutoSubject() {
        return this.autoSubject;
    }

    public static class Builder {
        private final InternalPullRequest pullRequest;
        private final InternalApplicationUser user;
        private boolean autoSubject;
        private Date createdDate;
        private String message;
        private String strategyId;

        public Builder(@Nonnull InternalPullRequest pullRequest, @Nonnull InternalApplicationUser user) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            this.user = Objects.requireNonNull(user, "user");
        }

        @Nonnull
        public Builder autoSubject(boolean value) {
            this.autoSubject = value;
            return this.self();
        }

        @Nonnull
        public InternalAutoMergeRequest build() {
            return new InternalAutoMergeRequest(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = Objects.requireNonNull(value, "createdDate");
            return this.self();
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder strategyId(@Nullable String value) {
            this.strategyId = value;
            return this.self();
        }

        @Nonnull
        private Builder self() {
            return this;
        }
    }
}

