/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.automerge;

import com.atlassian.bitbucket.pull.automerge.AutoMergeSettings;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Entity
@Table(name="bb_auto_merge_settings", uniqueConstraints={@UniqueConstraint(name="uq_bb_auto_merge_settings_scp", columnNames={"scope_type", "scope_id"})})
@TableGenerator(allocationSize=20, pkColumnValue="bb_auto_merge_settings", name="autoMergeIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalAutoMergeSettings
implements AutoMergeSettings,
Initializable {
    public static final String ID_GEN = "autoMergeIdGenerator";
    public static final String TABLE = "bb_auto_merge_settings";
    @Column(name="enabled", nullable=false)
    private final boolean enabled;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="autoMergeIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @JoinColumn(name="scope_id", nullable=false, updatable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type", nullable=false, updatable=false))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1"), @MetaValue(targetEntity=InternalPersonalProject.class, value="2"), @MetaValue(targetEntity=InternalRepository.class, value="3")})
    private final Scopeable scope;

    protected InternalAutoMergeSettings() {
        this.id = 0L;
        this.enabled = false;
        this.scope = null;
    }

    private InternalAutoMergeSettings(@Nonnull Builder builder) {
        Objects.requireNonNull(builder, "builder");
        this.id = builder.id;
        this.enabled = builder.enabled;
        this.scope = Objects.requireNonNull(builder.scope, "scope");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalAutoMergeSettings) {
            InternalAutoMergeSettings that = (InternalAutoMergeSettings)o;
            return this.id == that.id && this.enabled == that.enabled && Objects.equals(this.scope, that.scope);
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Scope getScope() {
        if (this.scope == null) {
            throw new IllegalStateException("Auto merge settings can not be configured for the global scope");
        }
        return this.scope.toScope();
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.id, this.scope);
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.scope);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder {
        private final long id;
        private final Scopeable scope;
        private boolean enabled;

        public Builder(@Nonnull Scope scope, boolean enabled) {
            this.enabled = enabled;
            this.id = 0L;
            this.scope = Scopeable.fromScope(Objects.requireNonNull(scope, "scope"));
        }

        public Builder(@Nonnull InternalAutoMergeSettings settings) {
            Objects.requireNonNull(settings, "settings");
            this.enabled = settings.isEnabled();
            this.id = settings.id;
            this.scope = Scopeable.fromScope(settings.getScope());
        }

        @Nonnull
        public InternalAutoMergeSettings build() {
            return new InternalAutoMergeSettings(this);
        }

        @Nonnull
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }
    }
}

