/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.reviewer;

import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Entity
@Table(name="bb_reviewer_group", indexes={@Index(name="idx_bb_reviewer_group_scope", columnList="scope_id, scope_type")}, uniqueConstraints={@UniqueConstraint(name="uq_bb_reviewer_group_name", columnNames={"scope_id", "scope_type", "group_name"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalReviewerGroup
implements Initializable,
ReviewerGroup {
    public static final String TABLE = "bb_reviewer_group";
    private static final String ID_GEN = "reviewerGroupIdGenerator";
    private static final int NAME_LENGTH = 50;
    @Column(name="description")
    @OptionalString
    private String description;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="reviewerGroupIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, name="reviewerGroupIdGenerator", table="id_sequence", pkColumnValue="bb_reviewer_group")
    private final long id;
    @Column(name="group_name", nullable=false, length=50)
    @RequiredString(size=50)
    private final String name;
    @JoinColumn(name="scope_id", updatable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type"))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1"), @MetaValue(targetEntity=InternalRepository.class, value="3")})
    private final Scopeable scope;
    @JoinTable(name="bb_reviewer_group_user", indexes={@Index(name="idx_bb_reviewer_group_user", columnList="user_id")}, joinColumns={@JoinColumn(name="group_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="user_id", nullable=false)})
    @ManyToMany(targetEntity=InternalApplicationUser.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<ApplicationUser> users;

    protected InternalReviewerGroup() {
        this.description = null;
        this.id = 0L;
        this.name = null;
        this.scope = null;
        this.users = new HashSet<ApplicationUser>();
    }

    private InternalReviewerGroup(Builder builder) {
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.scope = builder.scope;
        this.users = builder.users;
    }

    public String getDescription() {
        return this.description;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope.toScope();
    }

    @Nonnull
    public Set<ApplicationUser> getUsers() {
        return Collections.unmodifiableSet(this.users);
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.scope);
        HibernateUtils.initialize(this.getUsers());
        for (ApplicationUser user : this.getUsers()) {
            HibernateUtils.initialize(user);
        }
    }

    public void removeUsers(ApplicationUser ... values) {
        this.users.removeAll(Arrays.asList(values));
    }

    public void removeUsers(@Nonnull Iterable<ApplicationUser> values) {
        this.removeUsers((ApplicationUser[])Iterables.toArray(values, ApplicationUser.class));
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private final Scopeable scope;
        private final Set<ApplicationUser> users;
        private String description;
        private String name;

        public Builder(@Nonnull InternalReviewerGroup reviewerGroup, @Nonnull Set<ApplicationUser> users) {
            Objects.requireNonNull(reviewerGroup, "reviewerGroup");
            Objects.requireNonNull(users, "users");
            this.users = new HashSet<ApplicationUser>(users);
            this.description = reviewerGroup.getDescription();
            this.id = reviewerGroup.getId();
            this.name = reviewerGroup.getName();
            this.scope = Scopeable.fromScope(reviewerGroup.getScope());
        }

        public Builder(@Nonnull InternalReviewerGroup reviewerGroup) {
            this(reviewerGroup, reviewerGroup.getUsers());
        }

        public Builder(@Nonnull String name, @Nonnull Scope scope) {
            this.name = Objects.requireNonNull(name, "name");
            this.scope = Scopeable.fromScope(scope);
            this.description = null;
            this.id = 0L;
            this.users = new HashSet<ApplicationUser>();
        }

        @Nonnull
        public InternalReviewerGroup build() {
            return new InternalReviewerGroup(this);
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this;
        }

        @Nonnull
        public Builder users(@Nonnull Iterable<ApplicationUser> values) {
            Builder.addIf(Objects::nonNull, this.users, values);
            return this;
        }

        @Nonnull
        public Builder users(@Nonnull ApplicationUser value, ApplicationUser ... values) {
            Builder.addIf(Objects::nonNull, this.users, (Object)value, (Object[])values);
            return this;
        }
    }
}

