/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.template;

import com.atlassian.bitbucket.dmz.pull.template.PullRequestTemplate;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_pull_request_template", indexes={@Index(name="idx_bb_pr_template_scope", columnList="scope_id, scope_type")}, uniqueConstraints={@UniqueConstraint(name="pk_bb_pr_template", columnNames={"id"})})
@TableGenerator(allocationSize=20, pkColumnValue="bb_pull_request_template", name="pullRequestTemplateIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalPullRequestTemplate
implements PullRequestTemplate,
Initializable {
    public static final String ID_GEN = "pullRequestTemplateIdGenerator";
    public static final String TABLE = "bb_pull_request_template";
    @Column(name="description")
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String description;
    @Column(name="enabled", nullable=false)
    private final boolean enabled;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="pullRequestTemplateIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @JoinColumn(name="scope_id", updatable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type"))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1"), @MetaValue(targetEntity=InternalPersonalProject.class, value="2"), @MetaValue(targetEntity=InternalRepository.class, value="3")})
    private final Scopeable scope;

    protected InternalPullRequestTemplate() {
        this.id = 0L;
        this.scope = null;
        this.description = null;
        this.enabled = false;
    }

    private InternalPullRequestTemplate(Builder builder) {
        this.id = builder.id;
        this.scope = builder.scope;
        this.description = builder.description;
        this.enabled = builder.enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public Scope getScope() {
        return this.scope.toScope();
    }

    @Override
    public void initialize() {
        Hibernate.initialize((Object)this.scope);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private final Scopeable scope;
        private String description;
        private boolean enabled;

        public Builder(@Nonnull Scope templateScope) {
            this.id = 0L;
            this.scope = Scopeable.fromScope(templateScope);
            this.enabled = false;
        }

        public Builder(@Nonnull InternalPullRequestTemplate template) {
            this.id = Objects.requireNonNull(template, (String)"template").id;
            this.scope = Scopeable.fromScope(template.getScope());
            this.description = StringUtils.trimToNull((String)template.getDescription());
            this.enabled = template.isEnabled();
        }

        @Nonnull
        public InternalPullRequestTemplate build() {
            return new InternalPullRequestTemplate(this);
        }

        @Nonnull
        public Builder description(@Nullable String description) {
            this.description = StringUtils.trimToNull((String)description);
            return this;
        }

        @Nonnull
        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

