/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
@MappedSuperclass
public class InternalRefChange
implements RefChange {
    @Column(name="from_hash", length=40)
    @OptionalString
    private final String fromHash;
    @Transient
    private MinimalRef ref;
    @Column(name="ref_id", nullable=false, length=1024)
    @RequiredString(size=1024)
    private final String refId;
    @Column(name="to_hash", length=40)
    @OptionalString
    private final String toHash;
    @Column(name="change_type", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.repository.RefChangeType")})
    private final RefChangeType type;

    public InternalRefChange(@Nonnull RefChange refChange) {
        Objects.requireNonNull(refChange, "refChange");
        this.fromHash = StringUtils.trimToNull((String)refChange.getFromHash());
        this.refId = Objects.requireNonNull(refChange.getRef(), "refChange.ref").getId();
        this.toHash = StringUtils.trimToNull((String)refChange.getToHash());
        this.type = refChange.getType();
    }

    public InternalRefChange(@Nonnull String refId) {
        this.refId = Objects.requireNonNull(refId, "refId");
        this.toHash = null;
        this.fromHash = null;
        this.type = RefChangeType.UPDATE;
    }

    protected InternalRefChange() {
        this.toHash = null;
        this.refId = null;
        this.fromHash = null;
        this.type = null;
    }

    public static Object formatRefChanges(final Iterable<RefChange> refChanges) {
        return new Object(){

            public String toString() {
                StringBuilder builder = new StringBuilder();
                for (RefChange refChange : refChanges) {
                    builder.append("\n- ").append(refChange);
                }
                return builder.toString();
            }
        };
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    @Nonnull
    public MinimalRef getRef() {
        if (this.ref == null) {
            SimpleMinimalRef.Builder builder = (SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().id(this.refId);
            if (this.refId.startsWith("refs/tags/")) {
                ((SimpleMinimalRef.Builder)builder.displayId(this.refId.substring(10))).type((RefType)StandardRefType.TAG);
            } else {
                ((SimpleMinimalRef.Builder)builder.displayId(this.refId.startsWith("refs/heads/") ? this.refId.substring(11) : this.refId)).type((RefType)StandardRefType.BRANCH);
            }
            this.ref = builder.build();
        }
        return this.ref;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    @Nonnull
    public RefChangeType getType() {
        return this.type;
    }

    public String toString() {
        return this.getRef().getId() + ": " + this.getFromHash() + " -> " + this.getToHash() + " (" + String.valueOf(this.getType()) + ")";
    }
}

