/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.label.LabelableVisitor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.ConstraintNature;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.repository.RepositoryOfflineSupplier;
import com.atlassian.stash.internal.scope.Scopeable;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.atlassian.stash.internal.validation.RepositoryUniqueness;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.text.Normalizer;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@RepositoryUniqueness(groups={Create.class, Update.class}, payload={ConstraintNature.Conflict.class})
@Table(name="repository", indexes={@Index(name="idx_repository_hierarchy_id", columnList="hierarchy_id"), @Index(name="idx_repository_project_id", columnList="project_id"), @Index(name="idx_repository_state", columnList="state"), @Index(name="idx_repository_store_id", columnList="store_id")}, uniqueConstraints={@UniqueConstraint(name="uk_slug_project_id", columnNames={"slug", "project_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalRepository
implements DmzRepository,
Initializable,
InternalWatchable,
Scopeable {
    public static final String TABLE = "repository";
    public static final int TOKEN_LENGTH = 20;
    private static final String ID_GEN = "repoIdGenerator";
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=InternalDataStore.class)
    @JoinColumn(name="store_id", foreignKey=@ForeignKey(name="fk_repository_store_id"))
    private final InternalDataStore dataStore;
    @Column(name="description")
    private final String description;
    @Column(name="is_archived", nullable=false)
    private final boolean archived;
    @Column(name="is_forkable", nullable=false)
    private final boolean forkable;
    @Column(name="is_public", nullable=false)
    private final boolean publiclyAccessible;
    @Column(name="is_read_only", nullable=false)
    private final boolean readOnly;
    @Column(name="hierarchy_id", length=20, nullable=false, updatable=false)
    @RequiredString(size=20)
    private final String hierarchyId;
    @Id
    @GeneratedValue(generator="repoIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="repoIdGenerator", table="id_sequence", pkColumnValue="repository", allocationSize=10)
    private final int id;
    @Column(name="name")
    private final String name;
    @OneToOne(fetch=FetchType.LAZY, targetEntity=InternalRepository.class)
    @JoinTable(name="sta_repo_origin", joinColumns={@JoinColumn(name="repository_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="origin_id", nullable=false)})
    private final InternalRepository origin;
    @Column(name="partition_id")
    private final Integer partition;
    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=InternalProject.class)
    @JoinColumn(name="project_id", nullable=false)
    private InternalProject project;
    @Column(name="scm_id", nullable=false, updatable=false)
    private final String scmId;
    @Column(name="slug")
    private final String slug;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.repository.Repository$State")})
    private final Repository.State state;
    @Transient
    private volatile RepositoryOfflineSupplier offlineSupplier;

    protected InternalRepository() {
        this.archived = false;
        this.dataStore = null;
        this.description = null;
        this.forkable = true;
        this.hierarchyId = null;
        this.id = 0;
        this.name = null;
        this.origin = null;
        this.partition = null;
        this.publiclyAccessible = false;
        this.readOnly = false;
        this.scmId = null;
        this.slug = null;
        this.state = null;
    }

    private InternalRepository(Builder builder) {
        this.archived = builder.archived;
        this.dataStore = builder.dataStore;
        this.description = builder.description;
        this.forkable = builder.forkable;
        this.hierarchyId = builder.hierarchyId;
        this.id = builder.id;
        this.name = builder.name;
        this.origin = builder.origin;
        this.partition = builder.partition < 0 ? null : Integer.valueOf(builder.partition);
        this.project = builder.project;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.readOnly = builder.readOnly;
        this.scmId = builder.scmId;
        this.slug = builder.slug == null ? InternalRepository.slugify(this.name) : builder.slug;
        this.state = (Repository.State)MoreObjects.firstNonNull((Object)builder.state, (Object)Repository.State.INITIALISING);
    }

    public <T> T accept(@Nonnull LabelableVisitor<T> visitor) {
        return (T)visitor.visit((Repository)this);
    }

    public <T> T accept(@Nonnull WatchableVisitor<T> visitor) {
        return (T)visitor.visit((Repository)this);
    }

    public String getDescription() {
        return this.description;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalRepository) {
            InternalRepository that = (InternalRepository)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    @Nonnull
    public Optional<InternalDataStore> getDataStore() {
        return Optional.ofNullable(this.dataStore);
    }

    @Nonnull
    public String getHierarchyId() {
        return this.hierarchyId;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public InternalRepository getOrigin() {
        return this.origin;
    }

    public int getPartition() {
        return this.partition == null ? -1 : this.partition;
    }

    @Nonnull
    public InternalProject getProject() {
        return this.project;
    }

    @Nonnull
    public String getScmId() {
        return this.scmId;
    }

    @Override
    @Nonnull
    public InternalRepository getScopeRepository() {
        return this;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    @Nonnull
    public Repository.State getState() {
        return this.isOffline() ? Repository.State.OFFLINE : this.state;
    }

    @Nonnull
    public String getStatusMessage() {
        return this.getState().getStatusMessage();
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public void initialize() {
        this.project = HibernateUtils.initialize(this.getProject());
        this.getDataStore().ifPresent(Hibernate::initialize);
        HibernateUtils.initialize(this.getOrigin());
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isFork() {
        return this.getOrigin() != null;
    }

    public boolean isForkable() {
        return this.forkable;
    }

    public boolean isLocal() {
        return this.partition == null;
    }

    public boolean isOffline() {
        return this.offlineSupplier != null && this.offlineSupplier.isOffline(this);
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRemote() {
        return this.partition != null;
    }

    public void setOfflineSupplier(RepositoryOfflineSupplier offlineSupplier) {
        this.offlineSupplier = offlineSupplier;
    }

    @Override
    @Nonnull
    public Scope toScope() {
        return Scopes.repository((Repository)this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append(this.getProject().getKey()).append('/').append(this.getSlug()).append('[').append(this.getId()).append(']').toString();
    }

    public static String slugify(String name) {
        return Normalizer.normalize(name, Normalizer.Form.NFKD).replaceAll("[^\\p{InBasicLatin}]+", "").replaceAll("[^a-zA-Z\\-_0-9.]+", "-").toLowerCase(Locale.US);
    }

    private Repository.State getInternalState() {
        return this.state;
    }

    public static class Builder
    extends BuilderSupport {
        private boolean archived;
        private InternalDataStore dataStore;
        private String description;
        private boolean forkable;
        private String hierarchyId;
        private int id;
        private String name;
        private InternalRepository origin;
        private int partition;
        private InternalProject project;
        private boolean publiclyAccessible;
        private boolean readOnly;
        private String scmId;
        private String slug;
        private Repository.State state;

        public Builder() {
            this.forkable = true;
            this.id = 0;
            this.partition = -1;
        }

        public Builder(@Nonnull InternalRepository repository) {
            this.archived = repository.isArchived();
            this.dataStore = Objects.requireNonNull(repository, InternalRepository.TABLE).getDataStore().orElse(null);
            this.description = repository.description;
            this.forkable = repository.isForkable();
            this.hierarchyId = repository.getHierarchyId();
            this.id = repository.getId();
            this.name = repository.getName();
            this.origin = repository.getOrigin();
            this.partition = repository.getPartition();
            this.project = repository.getProject();
            this.publiclyAccessible = repository.isPublic();
            this.readOnly = repository.isReadOnly();
            this.scmId = repository.getScmId();
            this.slug = repository.getSlug();
            this.state = repository.getInternalState();
        }

        @Nonnull
        public InternalRepository build() {
            return new InternalRepository(this);
        }

        @Nonnull
        public Builder archived(boolean value) {
            this.archived = value;
            return this;
        }

        @Nonnull
        public Builder dataStore(@Nullable InternalDataStore value) {
            this.dataStore = value;
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder forkable(boolean value) {
            this.forkable = value;
            return this;
        }

        @Nonnull
        public Builder hierarchyId(@Nonnull String value) {
            this.hierarchyId = Builder.requireNonBlank((String)value, (String)"hierarchyId");
            return this;
        }

        @Nonnull
        public Builder id(int value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Builder.requireNonBlank((String)value, (String)"name");
            this.slug = InternalRepository.slugify(value);
            return this;
        }

        @Nonnull
        public Builder origin(@Nullable InternalRepository value) {
            this.origin = value;
            return this;
        }

        @Nonnull
        public Builder partition(int value) {
            this.partition = value;
            return this;
        }

        @Nonnull
        public Builder project(@Nonnull InternalProject value) {
            this.project = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this;
        }

        @Nonnull
        public Builder readOnly(boolean value) {
            this.readOnly = value;
            return this;
        }

        @Nonnull
        public Builder scmId(@Nonnull String value) {
            this.scmId = Builder.requireNonBlank((String)value, (String)"scmId");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull Repository.State value) {
            this.state = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

