/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.RepositoryActivity;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.InternalActivity;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.Objects;

@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_sta_repo_activity_id"))
@Table(name="sta_repo_activity", indexes={@Index(name="idx_sta_repo_activity_repo", columnList="repository_id")})
public abstract class InternalRepositoryActivity
extends InternalActivity
implements RepositoryActivity {
    public static final String TABLE = "sta_repo_activity";
    @JoinColumn(name="repository_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_repo_activity_repo"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;

    protected InternalRepositoryActivity() {
    }

    protected InternalRepositoryActivity(AbstractRepositoryActivityBuilder<?, ?> builder) {
        super(builder);
        this.repository = builder.repository;
    }

    protected InternalRepositoryActivity(Date createdDate, long id, int type, InternalApplicationUser user, InternalRepository repository) {
        super(createdDate, id, type, user);
        this.repository = repository;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.repository = HibernateUtils.initialize(this.getRepository());
    }

    protected static abstract class AbstractRepositoryActivityBuilder<B extends AbstractRepositoryActivityBuilder<B, A>, A extends InternalRepositoryActivity>
    extends InternalActivity.AbstractActivityBuilder<B, A> {
        private final InternalRepository repository;

        protected AbstractRepositoryActivityBuilder(@Nonnull InternalRepository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        protected AbstractRepositoryActivityBuilder(@Nonnull A activity) {
            super(activity);
            this.repository = ((InternalRepositoryActivity)activity).getRepository();
        }
    }
}

