/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_repository_alias")
@TableGenerator(allocationSize=20, pkColumnValue="bb_repository_alias", name="repositoryAliasIdGenerator", table="id_sequence")
public class InternalRepositoryAlias
implements Initializable {
    public static final String ID_GEN = "repositoryAliasIdGenerator";
    public static final String TABLE = "bb_repository_alias";
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="repositoryAliasIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="project_key")
    private final String projectKey;
    @Type(type="com.atlassian.stash.internal.hibernate.NullPlaceholderStringType", parameters={@Parameter(name="placeholder", value="#")})
    @Column(name="project_namespace")
    @OptionalString
    private final String projectNamespace;
    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=InternalRepository.class)
    @JoinColumn(name="repository_id", nullable=false)
    private final InternalRepository repository;
    @Column(name="slug")
    private final String slug;

    protected InternalRepositoryAlias() {
        this.createdDate = null;
        this.id = 0L;
        this.projectKey = null;
        this.projectNamespace = null;
        this.repository = null;
        this.slug = null;
    }

    private InternalRepositoryAlias(Builder builder) {
        this.createdDate = new Date();
        this.id = builder.id;
        this.projectNamespace = null;
        this.projectKey = InternalProject.keyify(builder.projectKey);
        this.slug = StringUtils.lowerCase((String)builder.slug, (Locale)Locale.US);
        this.repository = builder.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalRepositoryAlias) {
            InternalRepositoryAlias that = (InternalRepositoryAlias)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    @RequiredString
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    @RequiredString
    public String getSlug() {
        return this.slug;
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getRepository());
    }

    public static class Builder {
        private final long id;
        private final InternalRepository repository;
        private String projectKey;
        private String slug;

        public Builder(@Nonnull InternalRepository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.id = 0L;
            this.projectKey = repository.getProject().getKey();
            this.slug = repository.getSlug();
        }

        @Nonnull
        public InternalRepositoryAlias build() {
            return new InternalRepositoryAlias(this);
        }

        @Nonnull
        public Builder project(@Nonnull InternalProject value) {
            this.projectKey = value.getKey();
            return this.self();
        }

        @Nonnull
        public Builder project(@Nonnull String key) {
            this.projectKey = Objects.requireNonNull(key, "key");
            return this.self();
        }

        @Nonnull
        public Builder slug(@Nonnull String value) {
            this.slug = Objects.requireNonNull(value, "slug");
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

