/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Cacheable
@Entity
@Table(name="sta_repo_hook", indexes={@Index(name="idx_sta_repo_hook_hook_key", columnList="hook_key"), @Index(name="idx_sta_repo_hook_lob_id", columnList="lob_id"), @Index(name="idx_sta_repo_hook_proj_id", columnList="project_id"), @Index(name="idx_sta_repo_hook_repo_id", columnList="repository_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_repo_hook_scope_hook", columnNames={"project_id", "repository_id", "hook_key"})})
@TableGenerator(allocationSize=20, pkColumnValue="sta_repo_hook", name="repositoryHookIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalRepositoryHook
implements Initializable {
    public static final String ID_GEN = "repositoryHookIdGenerator";
    public static final String TABLE = "sta_repo_hook";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="repositoryHookIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="is_enabled", nullable=false)
    private final boolean enabled;
    @Column(name="hook_key", nullable=false, updatable=false)
    @RequiredString
    private final String hookKey;
    @JoinColumn(name="project_id", foreignKey=@ForeignKey(name="fk_sta_repo_hook_proj"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalProject project;
    @JoinColumn(name="repository_id", foreignKey=@ForeignKey(name="fk_sta_repo_hook_repo"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalRepository repository;
    @JoinColumn(name="lob_id", foreignKey=@ForeignKey(name="fk_sta_repo_hook_lob"))
    @OneToOne(cascade={jakarta.persistence.CascadeType.MERGE}, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private final InternalSharedLob settings;

    protected InternalRepositoryHook() {
        this.enabled = false;
        this.hookKey = null;
        this.id = 0L;
        this.project = null;
        this.repository = null;
        this.settings = null;
    }

    private InternalRepositoryHook(Builder builder) {
        this.enabled = builder.enabled;
        this.hookKey = builder.hookKey;
        this.id = builder.id;
        this.project = builder.project;
        this.repository = builder.repository;
        this.settings = builder.settings == null ? null : builder.settings.build();
    }

    @Nonnull
    public String getHookKey() {
        return this.hookKey;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Scope getScope() {
        if (this.project != null) {
            return Scopes.project((Project)this.project);
        }
        if (this.repository != null) {
            return Scopes.repository((Repository)this.repository);
        }
        throw new IllegalStateException("Unexpected scope type, it should either be project or repository");
    }

    @Nullable
    public InternalSharedLob getSettings() {
        return this.settings;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.project);
        HibernateUtils.initialize(this.repository);
    }

    public boolean hasSettings() {
        return this.getSettings() != null;
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private boolean enabled;
        private String hookKey;
        private InternalProject project;
        private InternalRepository repository;
        private InternalSharedLob.Builder settings;

        public Builder() {
            this.id = 0L;
        }

        public Builder(@Nonnull InternalRepositoryHook hook) {
            Objects.requireNonNull(hook, "hook");
            this.enabled = hook.isEnabled();
            this.hookKey = hook.getHookKey();
            this.id = hook.getId();
            this.settings = hook.getSettings() == null ? null : new InternalSharedLob.Builder(hook.getSettings());
            this.project = hook.project;
            this.repository = hook.repository;
        }

        @Nonnull
        public InternalRepositoryHook build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.hookKey), (Object)"The hook key is required");
            Preconditions.checkState((this.project != null || this.repository != null ? 1 : 0) != 0, (Object)"Either project or repository scope must be specified");
            return new InternalRepositoryHook(this);
        }

        @Nonnull
        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public Builder hookKey(@Nonnull String value) {
            this.hookKey = Builder.checkNotBlank((String)value, (String)"hookKey");
            return this;
        }

        @Nonnull
        public Builder scope(@Nonnull Scope value) {
            Objects.requireNonNull(value, "scope").accept((ScopeVisitor)new ScopeVisitor<Void>(){

                public Void visit(@Nonnull GlobalScope scope) {
                    throw new IllegalArgumentException("InternalRepositoryHook cannot be created at global scope");
                }

                public Void visit(@Nonnull ProjectScope scope) {
                    project = (InternalProject)scope.getProject();
                    repository = null;
                    return null;
                }

                public Void visit(@Nonnull RepositoryScope scope) {
                    repository = (InternalRepository)scope.getRepository();
                    project = null;
                    return null;
                }
            });
            return this;
        }

        @Nonnull
        public Builder settings(@Nullable InternalSharedLob value) {
            this.settings = value == null ? null : new InternalSharedLob.Builder(value);
            return this;
        }

        @Nonnull
        public Builder settings(@Nullable String value) {
            if (value == null) {
                this.settings = null;
            } else {
                if (this.settings == null) {
                    this.settings = new InternalSharedLob.Builder();
                }
                this.settings.data(value);
            }
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

