/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.dmz.repository.RefUpdateType;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RepositoryActivityVisitor;
import com.atlassian.bitbucket.repository.RepositoryPushActivity;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.repository.InternalPushRefChange;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryActivity;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DiscriminatorValue(value="6")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_sta_repo_push_act_id"))
@Table(name="sta_repo_push_activity")
public class InternalRepositoryPushActivity
extends InternalRepositoryActivity
implements RepositoryPushActivity {
    static final int MIN_HASH_LENGTH = 7;
    static final String TABLE = "sta_repo_push_activity";
    private static final Logger log = LoggerFactory.getLogger(InternalRepositoryPushActivity.class);
    @CollectionTable(name="sta_repo_push_ref", joinColumns={@JoinColumn(name="activity_id", nullable=false)}, indexes={@Index(name="idx_sta_repo_push_ref_chg_type", columnList="change_type")})
    @ElementCollection(targetClass=InternalPushRefChange.class)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private final Set<RefChange> refChanges;
    @Column(name="trigger_id", length=64, nullable=false)
    @RequiredString(size=64)
    private final String triggerId;

    protected InternalRepositoryPushActivity() {
        this.refChanges = new HashSet<RefChange>();
        this.triggerId = null;
    }

    private InternalRepositoryPushActivity(Builder builder) {
        super(builder);
        this.refChanges = builder.refChanges.build();
        this.triggerId = (String)MoreObjects.firstNonNull((Object)builder.triggerId, (Object)StandardRepositoryHookTrigger.REPO_PUSH.getId());
    }

    public <T> T accept(@Nonnull RepositoryActivityVisitor<T> visitor) {
        return (T)visitor.visit((RepositoryPushActivity)this);
    }

    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Nonnull
    public String getTriggerId() {
        return this.triggerId;
    }

    private static boolean isInvalidHash(String hash) {
        if (hash == null) {
            return true;
        }
        int length = hash.length();
        return length < 7 || length > 40;
    }

    @Nullable
    private static InternalPushRefChange maybeTransform(@Nullable RefChange change) {
        if (change == null) {
            return null;
        }
        if (change.getRef() == null || change.getType() == null || StringUtils.isBlank((CharSequence)change.getRef().getId()) || InternalRepositoryPushActivity.isInvalidHash(change.getFromHash()) || InternalRepositoryPushActivity.isInvalidHash(change.getToHash())) {
            MinimalRef ref = change.getRef();
            log.debug("Failed to transform RefChange: (refId: {}, fromHash: {}, toHash:{}, type: {})", new Object[]{ref == null ? null : ref.getId(), change.getFromHash(), change.getToHash(), change.getType()});
            return null;
        }
        if (change instanceof InternalPushRefChange) {
            return (InternalPushRefChange)change;
        }
        return new InternalPushRefChange(change, RefUpdateType.UNKNOWN);
    }

    public static class Builder
    extends InternalRepositoryActivity.AbstractRepositoryActivityBuilder<Builder, InternalRepositoryPushActivity> {
        private final ImmutableSet.Builder<RefChange> refChanges = ImmutableSet.builder();
        private String triggerId;

        public Builder(@Nonnull InternalRepository repository) {
            super(repository);
        }

        public Builder(@Nonnull InternalRepositoryPushActivity activity) {
            super(activity);
            this.refChanges.addAll(activity.getRefChanges());
            this.triggerId = activity.getTriggerId();
        }

        @Override
        @Nonnull
        public InternalRepositoryPushActivity build() {
            return new InternalRepositoryPushActivity(this);
        }

        @Nonnull
        public Builder refChanges(@Nonnull Collection<? extends RefChange> value) {
            Objects.requireNonNull(value, "refChanges").stream().map(InternalRepositoryPushActivity::maybeTransform).filter(Objects::nonNull).forEach(arg_0 -> this.refChanges.add(arg_0));
            return this.self();
        }

        @Nonnull
        public Builder triggerId(@Nonnull String value) {
            this.triggerId = Builder.requireNonBlank((String)value, (String)"triggerId");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

