/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.RepositorySize;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Entity
@Table(name="bb_repo_size")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalRepositorySize
implements RepositorySize {
    public static final String TABLE = "bb_repo_size";
    @Column(name="repo_id", nullable=false, unique=true, updatable=false)
    @Id
    private final int repositoryId;
    @Column(name="total", nullable=false)
    private long total;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;

    protected InternalRepositorySize() {
        this.repositoryId = 0;
        this.updatedDate = null;
    }

    private InternalRepositorySize(Builder builder) {
        this.repositoryId = builder.repositoryId;
        this.total = builder.total;
        this.updatedDate = builder.updatedDate == null ? new Date() : builder.updatedDate;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public long getTotal() {
        return this.total;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean isUpdatedSince(@Nonnull Instant since) {
        return this.updatedDate.toInstant().isAfter(Objects.requireNonNull(since, "since"));
    }

    public static class Builder {
        private final int repositoryId;
        private long total;
        private Date updatedDate;

        public Builder(@Nonnull Repository repository) {
            this.repositoryId = Objects.requireNonNull(repository, "repository").getId();
        }

        public Builder(@Nonnull InternalRepositorySize internalRepositorySize) {
            Objects.requireNonNull(internalRepositorySize, "internalRepositorySize");
            this.repositoryId = internalRepositorySize.repositoryId;
            this.total = internalRepositorySize.total;
        }

        public Builder(int repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Nonnull
        public InternalRepositorySize build() {
            return new InternalRepositorySize(this);
        }

        @Nonnull
        public Builder totalSize(long value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = Objects.requireNonNull(value, "updatedDate");
            return this;
        }
    }
}

