/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.scheduler.config.CronScheduleInfo;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.InternalClusteredJob;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import java.util.Objects;
import java.util.TimeZone;

@DiscriminatorValue(value="0")
@Entity
public class InternalClusteredCronJob
extends InternalClusteredJob {
    @Column(name="cron_expression")
    @OptionalString(size=255)
    private final String cronExpression;
    @Column(name="time_zone")
    private final TimeZone timeZone;

    protected InternalClusteredCronJob() {
        this.cronExpression = null;
        this.timeZone = null;
    }

    protected InternalClusteredCronJob(InternalClusteredJob.Builder builder) {
        super(builder);
        CronScheduleInfo cronScheduleInfo = builder.schedule.getCronScheduleInfo();
        this.cronExpression = cronScheduleInfo.getCronExpression();
        this.timeZone = cronScheduleInfo.getTimeZone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalClusteredCronJob) {
            InternalClusteredCronJob that = (InternalClusteredCronJob)o;
            return super.equals(that) && Objects.equals(this.cronExpression, that.cronExpression) && Objects.equals(this.timeZone, that.timeZone);
        }
        return false;
    }

    @Override
    @Nonnull
    public Schedule getSchedule() {
        return Schedule.forCronExpression((String)this.cronExpression, (TimeZone)this.timeZone);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

