/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.scheduler.config.IntervalScheduleInfo;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.InternalClusteredJob;
import com.atlassian.stash.internal.util.TimestampUtils;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;

@DiscriminatorValue(value="1")
@Entity
public class InternalClusteredIntervalJob
extends InternalClusteredJob {
    @Column(name="interval_millis")
    private final Long intervalMillis;
    @Column(name="first_run")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date firstRun;

    protected InternalClusteredIntervalJob() {
        this.intervalMillis = null;
        this.firstRun = null;
    }

    protected InternalClusteredIntervalJob(InternalClusteredJob.Builder builder) {
        super(builder);
        IntervalScheduleInfo intervalScheduleInfo = builder.schedule.getIntervalScheduleInfo();
        this.intervalMillis = intervalScheduleInfo.getIntervalInMillis();
        this.firstRun = intervalScheduleInfo.getFirstRunTime();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalClusteredIntervalJob) {
            InternalClusteredIntervalJob that = (InternalClusteredIntervalJob)o;
            return super.equals(that) && Objects.equals(this.intervalMillis, that.intervalMillis) && TimestampUtils.equalWithRounding(this.firstRun, that.firstRun);
        }
        return false;
    }

    @Override
    @Nonnull
    public Schedule getSchedule() {
        return Schedule.forInterval((long)this.intervalMillis, (Date)this.firstRun);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

