/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.scheduler.caesium.spi.ClusteredJob;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.InternalClusteredCronJob;
import com.atlassian.stash.internal.scheduling.InternalClusteredIntervalJob;
import com.atlassian.stash.internal.util.TimestampUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@DiscriminatorColumn(name="sched_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="bb_clusteredjob", indexes={@Index(name="idx_bb_clusteredjob_jrk", columnList="job_runner_key"), @Index(name="idx_bb_clusteredjob_next_run", columnList="next_run")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalClusteredJob
implements ClusteredJob {
    public static final String TABLE = "bb_clusteredjob";
    @Column(name="job_id", nullable=false, unique=true, updatable=false)
    @Id
    @RequiredString(size=255)
    private final String jobId;
    @Column(name="job_runner_key", nullable=false, updatable=false)
    @RequiredString(size=255)
    private final String jobRunnerKey;
    @Column(name="next_run")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date nextRun;
    @Column(name="version", nullable=false)
    private final long version;
    @Column(name="parameters", length=0x7FFFFFFF)
    private final byte[] parameters;

    protected InternalClusteredJob() {
        this.jobId = null;
        this.jobRunnerKey = null;
        this.nextRun = null;
        this.version = 0L;
        this.parameters = null;
    }

    protected InternalClusteredJob(Builder builder) {
        this.jobId = builder.jobId.toString();
        this.jobRunnerKey = builder.jobRunnerKey.toString();
        this.nextRun = builder.nextRun;
        this.version = builder.version;
        this.parameters = builder.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalClusteredJob) {
            InternalClusteredJob that = (InternalClusteredJob)o;
            return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.jobRunnerKey, that.jobRunnerKey) && TimestampUtils.equalWithRounding(this.nextRun, that.nextRun) && Objects.equals(this.version, that.version) && Arrays.equals(this.parameters, that.parameters);
        }
        return false;
    }

    @Nonnull
    public JobId getJobId() {
        return JobId.of((String)this.jobId);
    }

    @Nonnull
    public JobRunnerKey getJobRunnerKey() {
        return JobRunnerKey.of((String)this.jobRunnerKey);
    }

    @Nullable
    public Date getNextRunTime() {
        return this.nextRun;
    }

    @Nonnull
    public abstract Schedule getSchedule();

    public long getVersion() {
        return this.version;
    }

    @Nullable
    public byte[] getRawParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return Objects.hash(this.jobId);
    }

    public static class Builder {
        protected final Schedule schedule;
        private final JobId jobId;
        private final JobRunnerKey jobRunnerKey;
        private final long version;
        private Date nextRun;
        private byte[] parameters;

        public Builder(@Nonnull JobId jobId, @Nonnull JobRunnerKey jobRunnerKey, @Nonnull Schedule schedule) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            this.jobRunnerKey = Objects.requireNonNull(jobRunnerKey, "jobRunnerKey");
            this.schedule = Objects.requireNonNull(schedule, "schedule");
            this.version = 0L;
        }

        public Builder(@Nonnull ClusteredJob clusteredJob) {
            Objects.requireNonNull(clusteredJob, "clusteredJob");
            this.jobId = clusteredJob.getJobId();
            this.jobRunnerKey = clusteredJob.getJobRunnerKey();
            this.schedule = clusteredJob.getSchedule();
            this.version = clusteredJob.getVersion();
            this.nextRun = clusteredJob.getNextRunTime();
            this.parameters = clusteredJob.getRawParameters();
        }

        @Nonnull
        public InternalClusteredJob build() {
            switch (this.schedule.getType()) {
                case CRON_EXPRESSION: {
                    return new InternalClusteredCronJob(this);
                }
                case INTERVAL: {
                    return new InternalClusteredIntervalJob(this);
                }
            }
            throw new IllegalStateException("Unknown Schedule.Type " + String.valueOf(this.schedule.getType()));
        }

        @Nonnull
        public Builder nextRun(@Nullable Date value) {
            this.nextRun = value;
            return this;
        }

        @Nonnull
        public Builder parameters(@Nullable byte[] value) {
            this.parameters = value == null ? null : Arrays.copyOf(value, value.length);
            return this;
        }
    }
}

