/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.util.Objects;

@MappedSuperclass
public abstract class InternalAbstractGitPullRequestCacheEntity {
    @Column(name="from_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String fromHash;
    @Column(name="id", nullable=false, unique=true)
    @Id
    private final long id;
    @Column(name="to_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String toHash;

    protected InternalAbstractGitPullRequestCacheEntity() {
        this.toHash = null;
        this.fromHash = null;
        this.id = 0L;
    }

    protected InternalAbstractGitPullRequestCacheEntity(AbstractBuilder<?, ?> builder) {
        this.fromHash = Objects.requireNonNull(builder.fromHash, "fromHash");
        this.id = builder.id;
        this.toHash = Objects.requireNonNull(builder.toHash, "toHash");
    }

    @Nonnull
    public String getFromHash() {
        return this.fromHash;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public boolean isCurrent(@Nonnull PullRequest pullRequest) {
        return Objects.equals(this.getToHash(), pullRequest.getToRef().getLatestCommit()) && Objects.equals(this.getFromHash(), pullRequest.getFromRef().getLatestCommit());
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, E>, E extends InternalAbstractGitPullRequestCacheEntity>
    extends BuilderSupport {
        private final long id;
        private String fromHash;
        private String toHash;

        public AbstractBuilder(@Nonnull PullRequest pullRequest) {
            this.id = ((InternalPullRequest)Objects.requireNonNull(pullRequest, "pullRequest")).getGlobalId();
            this.refs(pullRequest);
        }

        public AbstractBuilder(@Nonnull InternalAbstractGitPullRequestCacheEntity value) {
            this.id = Objects.requireNonNull(value, "value").getId();
        }

        @Nonnull
        public abstract E build();

        @Nonnull
        public B fromHash(@Nonnull String value) {
            this.fromHash = AbstractBuilder.requireNonBlank((String)value, (String)"fromHash");
            return this.self();
        }

        @Nonnull
        public B refs(@Nonnull PullRequest pullRequest) {
            Objects.requireNonNull(pullRequest);
            this.fromHash = pullRequest.getFromRef().getLatestCommit();
            this.toHash = pullRequest.getToRef().getLatestCommit();
            return this.self();
        }

        @Nonnull
        public B toHash(@Nonnull String value) {
            this.toHash = AbstractBuilder.requireNonBlank((String)value, (String)"toHash");
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

