/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.scm.git.pull.InternalAbstractGitPullRequestCacheEntity;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Objects;

@Entity
@Table(name="bb_git_pr_common_ancestor")
public class InternalGitPullRequestCachedAncestor
extends InternalAbstractGitPullRequestCacheEntity {
    public static final String TABLE = "bb_git_pr_common_ancestor";
    @Column(name="ancestor_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String ancestorHash;

    protected InternalGitPullRequestCachedAncestor() {
        this.ancestorHash = null;
    }

    private InternalGitPullRequestCachedAncestor(Builder builder) {
        super(builder);
        this.ancestorHash = Objects.requireNonNull(builder.ancestorHash, "ancestorHash");
    }

    @Nonnull
    public String getAncestorHash() {
        return this.ancestorHash;
    }

    public static class Builder
    extends InternalAbstractGitPullRequestCacheEntity.AbstractBuilder<Builder, InternalGitPullRequestCachedAncestor> {
        private String ancestorHash;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
        }

        public Builder(@Nonnull InternalGitPullRequestCachedAncestor value) {
            super(value);
        }

        @Nonnull
        public Builder ancestorHash(@Nonnull String value) {
            this.ancestorHash = Builder.requireNonBlank((String)value, (String)"ancestor");
            return this.self();
        }

        @Override
        @Nonnull
        public InternalGitPullRequestCachedAncestor build() {
            return new InternalGitPullRequestCachedAncestor(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

