/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scope;

import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public interface Scopeable {
    @Nullable
    public static Scopeable fromScope(@Nonnull Scope scope) {
        return (Scopeable)Objects.requireNonNull(scope, "scope").accept((ScopeVisitor)new ScopeVisitor<Scopeable>(){

            public Scopeable visit(@Nonnull ProjectScope scope) {
                return (Scopeable)scope.getProject().accept((ProjectVisitor)new ProjectVisitor<Scopeable>(this){

                    public Scopeable visit(@Nonnull Project project) {
                        return (InternalNormalProject)project;
                    }

                    public Scopeable visit(@Nonnull PersonalProject project) {
                        return (InternalPersonalProject)project;
                    }
                });
            }

            public Scopeable visit(@Nonnull RepositoryScope scope) {
                return (InternalRepository)scope.getRepository();
            }

            public Scopeable visit(@Nonnull GlobalScope scope) {
                return null;
            }
        });
    }

    @Nonnull
    public Scope toScope();
}

