/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secrets;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.secrets.api.SealedSecret;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Cacheable
@Entity
@Table(name="bb_sealed_secret", indexes={@Index(name="idx_bb_sea_sec_backend_id", columnList="backend_id")})
public class InternalSealedSecret {
    public static final String TABLE = "bb_sealed_secret";
    @Column(name="backend_id", nullable=false)
    @RequiredString
    private final String backendId;
    @Column(name="identifier", nullable=false, unique=true)
    @Id
    @RequiredString(size=1024)
    private final String identifier;
    @Column(name="sealed_value", nullable=false)
    @Lob
    @RequiredString(size=0x7FFFFFFF)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String sealedValue;

    protected InternalSealedSecret() {
        this.backendId = null;
        this.identifier = null;
        this.sealedValue = null;
    }

    private InternalSealedSecret(Builder builder) {
        this.backendId = Objects.requireNonNull(builder.backendId, "backendId");
        this.identifier = Objects.requireNonNull(builder.identifier, "identifier");
        this.sealedValue = Objects.requireNonNull(builder.sealedValue, "sealedValue");
    }

    @Nonnull
    public String getBackendId() {
        return this.backendId;
    }

    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public String getSealedValue() {
        return this.sealedValue;
    }

    public SealedSecret toSealedSecret() {
        return SealedSecret.from((String)this.sealedValue);
    }

    public static class Builder {
        private final String backendId;
        private final String identifier;
        private final String sealedValue;

        public Builder(@Nonnull SealedSecret sealedSecret) {
            Objects.requireNonNull(sealedSecret, "sealedSecret");
            this.backendId = sealedSecret.getBackendId();
            this.identifier = sealedSecret.getIdentifier();
            this.sealedValue = sealedSecret.toString();
        }

        @Nonnull
        public InternalSealedSecret build() {
            return new InternalSealedSecret(this);
        }
    }
}

