/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secretscanning;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningAllowlistRule;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Entity
@Table(name="bb_secret_allowlist_rule", indexes={})
@TableGenerator(allocationSize=25, pkColumnValue="bb_secret_allowlist_rule", initialValue=10, name="secretScanAllowlistRuleIdGenerator", table="id_sequence")
public class InternalSecretScanningAllowlistRule
implements DmzSecretScanningAllowlistRule,
Initializable {
    static final String ID_GEN = "secretScanAllowlistRuleIdGenerator";
    static final String TABLE = "bb_secret_allowlist_rule";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="secretScanAllowlistRuleIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="name", nullable=false)
    @RequiredString
    private final String name;
    @Column(name="line_regex")
    @OptionalString(size=1024)
    private final String lineRegex;
    @Column(name="path_regex")
    @OptionalString(size=1024)
    private final String pathRegex;
    @JoinColumn(name="scope_id", updatable=false, nullable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type", nullable=false))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1"), @MetaValue(targetEntity=InternalRepository.class, value="3")})
    private final Scopeable scope;

    private InternalSecretScanningAllowlistRule(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.lineRegex = builder.lineRegex;
        this.pathRegex = builder.pathRegex;
        this.scope = Scopeable.fromScope(builder.scope);
    }

    protected InternalSecretScanningAllowlistRule() {
        this.id = 0L;
        this.name = null;
        this.lineRegex = null;
        this.pathRegex = null;
        this.scope = null;
    }

    @Nonnull
    public Builder copy() {
        return new Builder(this);
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Optional<String> getLineRegex() {
        return Optional.ofNullable(this.lineRegex);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Optional<String> getPathRegex() {
        return Optional.ofNullable(this.pathRegex);
    }

    @Nonnull
    public Scope getScope() {
        if (this.scope == null) {
            throw new UnsupportedOperationException("Allowlists cannot be managed at Global scope");
        }
        return this.scope.toScope();
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.scope);
    }

    public static class Builder
    extends BuilderSupport {
        private long id;
        private String lineRegex;
        private String name;
        private String pathRegex;
        private Scope scope;

        public Builder(@Nonnull String name) {
            this.id = 0L;
            this.name = Builder.requireNonBlank((String)name, (String)"name");
            this.scope = new GlobalScope();
        }

        public Builder(@Nonnull String name, long id) {
            this.id = id;
            this.name = Builder.requireNonBlank((String)name, (String)"name");
            this.scope = new GlobalScope();
        }

        private Builder(InternalSecretScanningAllowlistRule rule) {
            this.id = rule.id;
            this.lineRegex = rule.lineRegex;
            this.name = rule.name;
            this.pathRegex = rule.pathRegex;
            this.scope = rule.scope == null ? new GlobalScope() : rule.scope.toScope();
        }

        public InternalSecretScanningAllowlistRule build() {
            if (this.lineRegex == null && this.pathRegex == null) {
                throw new IllegalArgumentException("Either a line regular expression or a path regular expression is required");
            }
            return new InternalSecretScanningAllowlistRule(this);
        }

        @Nonnull
        public Builder id(long id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder lineRegex(@Nullable String value) {
            this.lineRegex = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder name(String value) {
            this.name = Builder.requireNonBlank((String)value, (String)"name");
            return this;
        }

        @Nonnull
        public Builder pathRegex(@Nullable String value) {
            this.pathRegex = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder scope(@Nonnull Scope value) {
            if (value.getType() == ScopeType.GLOBAL) {
                throw new UnsupportedOperationException("Allowlists cannot be managed at Global scope");
            }
            this.scope = value;
            return this;
        }
    }
}

