/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secretscanning;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningExemptRepository;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Entity
@Table(name="bb_ss_exempt_repo")
public class InternalSecretScanningExemptRepository
implements DmzSecretScanningExemptRepository,
Initializable {
    public static final String TABLE = "bb_ss_exempt_repo";
    @Column(name="repo_id", nullable=false, unique=true, updatable=false)
    @Id
    private final int repositoryId;
    @JoinColumn(name="repo_id", nullable=false)
    @OneToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;
    @JoinColumn(name="scope_id", updatable=false, nullable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type", nullable=false))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1")})
    private final Scopeable scope;

    protected InternalSecretScanningExemptRepository() {
        this.repositoryId = 0;
        this.scope = null;
    }

    private InternalSecretScanningExemptRepository(Builder builder) {
        this.repositoryId = builder.repositoryId;
        this.scope = Scopeable.fromScope(builder.scope);
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Scope getScope() {
        return this.scope == null ? Scopes.global() : this.scope.toScope();
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.scope);
        this.repository = HibernateUtils.initialize(this.repository);
    }

    public static class Builder {
        private final int repositoryId;
        private Scope scope;

        public Builder(@Nonnull Repository repository) {
            Objects.requireNonNull(repository, "repository");
            this.repositoryId = repository.getId();
            this.scope = Scopes.global();
        }

        @Nonnull
        public InternalSecretScanningExemptRepository build() {
            return new InternalSecretScanningExemptRepository(this);
        }

        public Builder scope(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            return this;
        }
    }
}

