/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ApplicationProperty {
    static final int MAX_VALUE_SIZE = 2000;
    private final Key key;
    @RequiredString(size=2000)
    private final String value;

    public ApplicationProperty(@Nonnull Key key, @Nonnull String value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ApplicationProperty) {
            ApplicationProperty property = (ApplicationProperty)o;
            return Objects.equals((Object)this.key, (Object)property.key) && Objects.equals(this.value, property.value);
        }
        return false;
    }

    public Key getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.value});
    }

    public String toString() {
        return ApplicationProperty.class.getSimpleName() + "{key=" + String.valueOf((Object)this.key) + ", value='" + this.value + "'}";
    }

    public static enum Key {
        NAME("instance.name"),
        AVATAR_SOURCE("avatar.source"),
        BASE_URL("instance.url"),
        DEFAULT_BRANCH("default.branch"),
        EMAIL_ADDRESS("mail.sender.address"),
        LAST_HOME("instance.home"),
        LAST_LICENSED_USER_COUNT("last.licensed.user.count"),
        LAST_OS("last.os"),
        LICENSE("license"),
        LICENSE_EXCEEDED_GRACE_PERIOD_START("license.exceeded.grace.period.start"),
        LOCALE("locale"),
        MODE("instance.application.mode"),
        SERVER_ID("server.id"),
        SERVER_TIMEZONE("server.tz"),
        MAIL_HOST("mail.host"),
        MAIL_HOST_PORT("mail.port"),
        MAIL_HOST_USERNAME("mail.username"),
        MAIL_HOST_PASSWORD("mail.password", true),
        MAIL_PROTOCOL("mail.protocol"),
        MAIL_OAUTH_PROVIDER_ID("mail.oauth.provider.id"),
        MAIL_OAUTH_TOKEN_ID("mail.oauth.token.id"),
        MAIL_USE_TLS("mail.useTls"),
        MAIL_REQUIRE_TLS("mail.requireTls"),
        MESH_REPOSITORY_CREATION("mesh.repository.creation"),
        ALLOW_PUBLIC_SIGNUP("auth.public.signup"),
        REQUIRE_CAPTCHA_ON_SIGNUP("auth.captcha.signup"),
        MAX_CAPTCHA_ATTEMPTS("auth.max.captcha"),
        SETUP_COMPLETED("setup.completed"),
        DEBUG_LOGGING_ENABLED("logging.debug.enabled"),
        PROFILING_ENABLED("profiling.enabled"),
        HTTP_SCM_HOSTING_ENABLED("scm.http.enabled"),
        RATE_LIMITING_DEFAULT_CAPACITY("rate.limiting.default.capacity"),
        RATE_LIMITING_DEFAULT_FILL_RATE("rate.limiting.default.fillRate"),
        RATE_LIMITING_ENABLED("rate.limiting.enabled"),
        REPOSITORY_ARCHIVE_POLICY("policy.repository.archive"),
        REPOSITORY_DELETE_POLICY("policy.repository.delete"),
        SECRET_SCAN_ON_PRIVATE_REPOSITORIES("secret.scan.personal.repositories"),
        MAX_AO_BUILD_STATUS_ID("build.status.migration.max.ao.id"),
        ROLLING_UPGRADE_ENABLED("rolling.upgrade.enabled"),
        ROLLING_UPGRADE_ORIGINAL_VERSION("rolling.upgrade.original.version"),
        SYSTEM_SIGNED_GIT_OBJECTS_ENABLED("system.signed.git.objects.enabled"),
        SYSTEM_SIGNED_GIT_OBJECTS_SECRET_PASSPHRASE("system.signed.git.objects.secret.passhrase", true),
        CROWD_ENCRYPTION_KEY_PATH("crowd.encryption.encryptor.keyPath"),
        CROWD_ENCRYPTION_UPGRADE_COMPLETED("crowd.encryption.upgrade.completed"),
        CLUSTER_ID("cluster.id");

        private final String id;
        private final boolean secret;

        private Key(String id) {
            this(id, false);
        }

        private Key(String id, boolean secret) {
            this.id = id;
            this.secret = secret;
        }

        public String getId() {
            return this.id;
        }

        public static Key fromId(String id) {
            for (Key key : Key.values()) {
                if (!key.id.equals(id)) continue;
                return key;
            }
            throw new IllegalArgumentException("No ApplicationProperty.Key matches the ID [" + id + "]");
        }

        public boolean isSecret() {
            return this.secret;
        }
    }
}

