/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DataStoreType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Cacheable
@Entity
@Table(name="bb_data_store", uniqueConstraints={@UniqueConstraint(name="uq_bb_data_store_path", columnNames={"ds_path"}), @UniqueConstraint(name="uq_bb_data_store_uuid", columnNames={"ds_uuid"})})
@TableGenerator(allocationSize=3, pkColumnValue="bb_data_store", name="dataStoreIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalDataStore
implements DataStore {
    public static final String ID_GEN = "dataStoreIdGenerator";
    public static final String TABLE = "bb_data_store";
    public static final int UUID_LENGTH = 40;
    @Transient
    private Path dir;
    @Transient
    private FileStore fileStore;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="dataStoreIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="ds_path", nullable=false, length=128, updatable=false)
    @RequiredString(size=128)
    private final String path;
    @Transient
    private final DataStoreType type;
    @Column(name="ds_uuid", nullable=false, length=40, updatable=false)
    @RequiredString(minimumSize=40, size=40)
    private final String uuid;

    protected InternalDataStore() {
        this.id = 0L;
        this.uuid = null;
        this.path = null;
        this.type = DataStoreType.DISTRIBUTED;
    }

    private InternalDataStore(Builder builder) {
        this.dir = builder.dir;
        this.id = builder.id;
        this.path = builder.path;
        this.type = builder.type;
        this.uuid = builder.uuid;
    }

    @Nonnull
    public Path getDir() {
        if (this.dir == null) {
            this.dir = Paths.get(this.getPath(), new String[0]);
        }
        return this.dir;
    }

    @Nonnull
    public Optional<String> getDescription() {
        try {
            return Optional.of(this.getFileStore().toString());
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public OptionalLong getTotalSpace() {
        return this.getFileStoreProperty(FileStore::getTotalSpace);
    }

    @Nonnull
    public DataStoreType getType() {
        return this.type;
    }

    @Nonnull
    public OptionalLong getUsableSpace() {
        return this.getFileStoreProperty(FileStore::getUsableSpace);
    }

    @Nonnull
    public OptionalLong getUsedSpace() {
        return this.getFileStoreProperty(fileStore -> fileStore.getTotalSpace() - fileStore.getUsableSpace());
    }

    @Nonnull
    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return "InternalDataStore{uuid: " + this.uuid + ", path: " + this.path + "}";
    }

    @Nonnull
    private FileStore getFileStore() throws IOException {
        if (this.fileStore == null) {
            this.fileStore = Files.getFileStore(this.getDir());
        }
        return this.fileStore;
    }

    private OptionalLong getFileStoreProperty(FileStorePropertyAccessor accessor) {
        try {
            return OptionalLong.of(accessor.get(this.getFileStore()));
        }
        catch (IOException e) {
            return OptionalLong.empty();
        }
    }

    public static class Builder
    extends BuilderSupport {
        private final Path dir;
        private final String path;
        private long id;
        private DataStoreType type = DataStoreType.DISTRIBUTED;
        private String uuid;

        public Builder(@Nonnull String path) {
            this.path = Builder.requireNonBlank((String)path, (String)"path");
            this.dir = null;
            this.id = 0L;
        }

        public Builder(@Nonnull Path path) {
            this.dir = Objects.requireNonNull(path, "path");
            this.path = path.toString();
            this.id = 0L;
        }

        @Nonnull
        public InternalDataStore build() {
            Objects.requireNonNull(this.type, "type");
            Builder.requireNonBlank((String)this.uuid, (String)"uuid");
            return new InternalDataStore(this);
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public Builder type(@Nonnull DataStoreType value) {
            this.type = Objects.requireNonNull(value, "uuid");
            return this.self();
        }

        @Nonnull
        public Builder uuid(@Nonnull String value) {
            if ((value = Builder.requireNonBlank((String)value, (String)"uuid").toLowerCase(Locale.ROOT)).length() > 40) {
                value = value.substring(0, 40);
            }
            this.uuid = value;
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }

    @FunctionalInterface
    private static interface FileStorePropertyAccessor {
        public long get(@Nonnull FileStore var1) throws IOException;
    }
}

