/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DataStoreConfig;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class SimpleDataStoreConfig
implements DataStoreConfig {
    private final List<DataStore> additional;
    private final DataStore sharedHome;

    private SimpleDataStoreConfig(Builder builder) {
        this.additional = builder.additional.build();
        this.sharedHome = builder.sharedHome;
    }

    @Nonnull
    public List<DataStore> getAdditional() {
        return this.additional;
    }

    @Nonnull
    public DataStore getSharedHome() {
        return this.sharedHome;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<DataStore> additional;
        private final DataStore sharedHome;

        public Builder(@Nonnull DataStore sharedHome) {
            this.sharedHome = Objects.requireNonNull(sharedHome, "sharedHome");
            this.additional = ImmutableList.builder();
        }

        @Nonnull
        public Builder additional(@Nonnull DataStore value) {
            this.additional.add((Object)Objects.requireNonNull(value));
            return this;
        }

        @Nonnull
        public Builder additional(@Nonnull Iterable<? extends DataStore> values) {
            Builder.addIf(Objects::nonNull, this.additional, values);
            return this;
        }

        @Nonnull
        public SimpleDataStoreConfig build() {
            return new SimpleDataStoreConfig(this);
        }
    }
}

