/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.setting;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;

@Entity
@Table(name="sta_shared_lob")
@TableGenerator(allocationSize=20, pkColumnValue="sta_shared_lob", name="sharedLobIdGenerator", table="id_sequence")
public class InternalSharedLob {
    public static final String ID_GEN = "sharedLobIdGenerator";
    public static final String TABLE = "sta_shared_lob";
    public static final int MAX_LOB_LENGTH = 32768;
    @Column(name="lob_data", nullable=false)
    @Lob
    @RequiredString(size=32768)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String data;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="sharedLobIdGenerator", strategy=GenerationType.TABLE)
    private final long id;

    protected InternalSharedLob() {
        this.data = null;
        this.id = 0L;
    }

    private InternalSharedLob(Builder builder) {
        this.data = builder.data;
        this.id = builder.id;
    }

    public String getData() {
        return this.data;
    }

    public long getId() {
        return this.id;
    }

    public static class Builder {
        private String data;
        private long id;

        public Builder() {
            this.id = 0L;
        }

        public Builder(InternalSharedLob lob) {
            this.data = Objects.requireNonNull(lob, "lob").getData();
            this.id = lob.getId();
        }

        @Nonnull
        public InternalSharedLob build() {
            Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"LOB data is required");
            return new InternalSharedLob(this);
        }

        @Nonnull
        public Builder data(@Nonnull String value) {
            Objects.requireNonNull(value, "data");
            Preconditions.checkArgument((StringUtils.length((CharSequence)value) <= 32768 ? 1 : 0) != 0, (Object)"The provided LOB data is too long");
            this.data = value;
            return this;
        }

        @Nonnull
        public Builder data(@Nonnull InternalSharedLob value) {
            this.data = value.getData();
            return this;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

