/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction;

import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionCreateRequest;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalProject;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Cacheable
@Entity
@Table(name="bb_settings_restriction", indexes={@Index(name="idx_bb_set_res_pid", columnList="project_id"), @Index(name="idx_bb_set_res_ps_pst", columnList="processed_state, processing_started_timestamp"), @Index(name="idx_bb_set_res_pa_id", columnList="processing_attempts, id")}, uniqueConstraints={@UniqueConstraint(name="uq_bb_settings_restriction", columnNames={"namespace", "feature_key", "component_key", "project_id"})})
@TableGenerator(allocationSize=10, pkColumnValue="bb_settings_restriction", name="projectSettingsRestrictionIdGenerator", table="id_sequence")
public class InternalProjectSettingsRestriction
implements Initializable,
DmzProjectSettingsRestriction {
    public static final String COMPONENT_NULL_SURROGATE = "#";
    public static final String ID_GEN = "projectSettingsRestrictionIdGenerator";
    public static final String TABLE = "bb_settings_restriction";
    @Column(name="component_key", nullable=false, updatable=false)
    @RequiredString
    private final String componentKey;
    @Column(name="feature_key", nullable=false, updatable=false)
    @RequiredString
    private final String featureKey;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="projectSettingsRestrictionIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="namespace", nullable=false, updatable=false)
    @RequiredString
    private final String namespace;
    @Column(name="processed_state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState")})
    private final RestrictionProcessedState processedState;
    @Column(name="processing_attempts", nullable=false)
    private final int processingAttempts;
    @Column(name="processing_started_timestamp")
    private final Instant processingStartedTimestamp;
    @JoinColumn(name="project_id", nullable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=InternalProject.class)
    private InternalProject project;

    protected InternalProjectSettingsRestriction() {
        this.id = 0L;
        this.componentKey = null;
        this.featureKey = null;
        this.namespace = null;
        this.processedState = null;
        this.processingAttempts = 0;
        this.processingStartedTimestamp = null;
        this.project = null;
    }

    private InternalProjectSettingsRestriction(Builder builder) {
        this.id = builder.id;
        this.componentKey = builder.settingsKey.getComponentKey().orElse(COMPONENT_NULL_SURROGATE);
        this.featureKey = builder.settingsKey.getFeatureKey();
        this.namespace = builder.settingsKey.getNamespace();
        this.processedState = builder.processedState;
        this.processingAttempts = builder.processingAttempts;
        this.processingStartedTimestamp = builder.processingStartedTimestamp;
        this.project = builder.project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        InternalProjectSettingsRestriction that = (InternalProjectSettingsRestriction)o;
        return this.id == that.id && Objects.equals(this.componentKey, that.componentKey) && Objects.equals(this.featureKey, that.featureKey) && Objects.equals(this.namespace, that.namespace) && this.processedState == that.processedState && this.processingAttempts == that.processingAttempts && Objects.equals(this.project, that.project);
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public RestrictionProcessedState getProcessedState() {
        return this.processedState;
    }

    public int getProcessingAttempts() {
        return this.processingAttempts;
    }

    @Nullable
    public Instant getProcessingStartedTimestamp() {
        return this.processingStartedTimestamp;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Nonnull
    public SettingsKey getSettingsKey() {
        SettingsKey.Builder builder = new SettingsKey.Builder(this.namespace, this.featureKey);
        if (!COMPONENT_NULL_SURROGATE.equals(this.componentKey)) {
            builder.componentKey(this.componentKey);
        }
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.componentKey, this.featureKey, this.namespace, this.processedState, this.processingAttempts, this.project);
    }

    @Override
    public void initialize() {
        this.project = HibernateUtils.initialize(this.project);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("project", (Object)this.project).add("settingsKey", (Object)this.getSettingsKey()).add("processedState", (Object)this.processedState).add("processingAttempts", this.processingAttempts).toString();
    }

    public static class Builder {
        private final InternalProject project;
        private final SettingsKey settingsKey;
        private long id;
        private RestrictionProcessedState processedState;
        private int processingAttempts;
        private Instant processingStartedTimestamp;

        public Builder(@Nonnull ProjectSettingsRestrictionCreateRequest request) {
            Objects.requireNonNull(request, "request");
            this.id = 0L;
            this.processedState = RestrictionProcessedState.UNPROCESSED;
            this.processingAttempts = 0;
            this.project = (InternalProject)request.getProject();
            this.settingsKey = request.getSettingsKey();
        }

        public Builder(@Nonnull InternalProjectSettingsRestriction restriction) {
            Objects.requireNonNull(restriction, "restriction");
            this.id = restriction.id;
            this.processedState = restriction.processedState;
            this.processingAttempts = restriction.processingAttempts;
            this.processingStartedTimestamp = restriction.processingStartedTimestamp;
            this.project = restriction.project;
            this.settingsKey = restriction.getSettingsKey();
        }

        @Nonnull
        public InternalProjectSettingsRestriction build() {
            return new InternalProjectSettingsRestriction(this);
        }

        @Nonnull
        public Builder id(long id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder processedState(@Nonnull RestrictionProcessedState processedState) {
            this.processedState = Objects.requireNonNull(processedState, "processedState");
            return this;
        }

        @Nonnull
        public Builder processingAttempts(int processingAttempts) {
            this.processingAttempts = processingAttempts;
            return this;
        }

        @Nonnull
        public Builder processingStartedTimestamp(@Nullable Instant processingStartedTimestamp) {
            this.processingStartedTimestamp = processingStartedTimestamp;
            return this;
        }
    }
}

