/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalServiceUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="stash_user")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalApplicationUser
implements ApplicationUser,
Serializable {
    public static final String ID_GEN = "userIdGenerator";
    public static final int MAX_GENERATED_SLUG_LENGTH = 126;
    public static final int MAX_SLUG_RETRY_COUNT = 10;
    public static final String TABLE = "stash_user";
    public static final InternalStashUserVisitor<User> TO_CROWD_USER = new ToCrowdUserVisitor();
    @Id
    @GeneratedValue(generator="userIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="userIdGenerator", table="id_sequence", pkColumnValue="stash_user", allocationSize=50)
    private final int id;

    protected InternalApplicationUser() {
        this.id = 0;
    }

    protected InternalApplicationUser(@Nonnull AbstractBuilder<?, ?> builder) {
        this.id = Objects.requireNonNull(builder, (String)"builder").id;
    }

    public static String generateSlug(SecureTokenGenerator tokenGenerator) {
        String slug = tokenGenerator.generateToken();
        if (slug.length() > 127) {
            slug = slug.substring(0, 127);
        }
        return slug;
    }

    public static String slugify(String name) {
        String slug = Normalizer.normalize(name, Normalizer.Form.NFKD).replaceAll("[:/?#@!$&'()*+,;=%\\\\\\[\\]]", "_");
        if (slug.length() > 126) {
            slug = slug.substring(0, 126);
        }
        return IdentifierUtils.toLowerCase((String)slug);
    }

    public abstract <T> T accept(@Nonnull InternalStashUserVisitor<T> var1);

    public abstract AbstractBuilder copy();

    public boolean equals(Object o) {
        return ApplicationUserEquality.equals((ApplicationUser)this, (Object)o);
    }

    public String getEmailAddress() {
        return null;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public abstract UserType getType();

    public int hashCode() {
        return ApplicationUserEquality.hashCode((ApplicationUser)this);
    }

    @Nonnull
    public String getUsername() {
        return this.getName();
    }

    private static String checkSlug(String slug) {
        Objects.requireNonNull(slug, "slug");
        Preconditions.checkArgument((!slug.trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank slug is required");
        Preconditions.checkArgument((slug.length() <= 127 ? 1 : 0) != 0, (Object)"The provided slug exceeds the maximum allowed length");
        String check = InternalApplicationUser.slugify(slug);
        if (slug.length() < 127) {
            Preconditions.checkArgument((boolean)slug.equals(check), (String)"The provided slug is not valid (%s != %s)", (Object)slug, (Object)check);
        } else if (slug.length() == 127) {
            Preconditions.checkArgument((slug.startsWith(check) && Character.isDigit(slug.charAt(126)) ? 1 : 0) != 0, (String)"The provided slug is not valid (%s != %s with a trailing digit)", (Object)slug, (Object)check);
        }
        return slug;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder, T extends InternalApplicationUser>
    extends BuilderSupport {
        protected String name;
        protected String slug;
        private int id;

        public AbstractBuilder() {
            this.id = 0;
        }

        public AbstractBuilder(@Nonnull InternalApplicationUser user) {
            this.id = Objects.requireNonNull(user, "user").getId();
            this.name = user.getName();
            this.slug = user.getSlug();
        }

        @Nonnull
        public abstract T build();

        @Nonnull
        public B id(int value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String value) {
            this.name = AbstractBuilder.checkNotBlank((String)value, (String)"name");
            this.slug = InternalApplicationUser.slugify(value);
            return this.self();
        }

        @Nonnull
        public B slug(@Nonnull String value) {
            this.slug = InternalApplicationUser.checkSlug(value);
            return this.self();
        }

        @Nonnull
        public B regenerateSlug() {
            this.slug = null;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }

    private static class ToCrowdUserVisitor
    implements InternalStashUserVisitor<User> {
        private ToCrowdUserVisitor() {
        }

        @Override
        public User visit(@Nonnull InternalNormalUser user) {
            return user.getBackingCrowdUser();
        }

        @Override
        public User visit(@Nonnull InternalServiceUser user) {
            return null;
        }
    }
}

